/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.listener;

import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.support.common.DelegateArkContainer;
import com.alipay.sofa.ark.support.listener.TestNGOnArk;
import java.lang.annotation.Annotation;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;

public class ArkTestNGInvokedMethodListener
implements IInvokedMethodListener {
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        Class testClass = method.getTestMethod().getTestClass().getRealClass();
        if (this.isTestOnArk(testClass)) {
            ClassLoaderUtils.pushContextClassLoader((ClassLoader)DelegateArkContainer.getTestClassLoader());
        } else {
            ClassLoaderUtils.pushContextClassLoader((ClassLoader)ClassLoader.getSystemClassLoader());
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        ClassLoaderUtils.pushContextClassLoader((ClassLoader)ClassLoader.getSystemClassLoader());
    }

    protected boolean isTestOnArk(Class testClass) {
        for (Annotation annotation : testClass.getAnnotations()) {
            String annotationType = annotation.annotationType().getCanonicalName();
            if (!annotationType.equals(TestNGOnArk.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }
}

