/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.tools;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;

public class ArtifactItem {
    private static final String GAV_SPLIT = ":";
    private String groupId;
    private String artifactId;
    private String version = "?";
    private String classifier;
    private String type = "jar";
    private String scope = "compile";

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String toString() {
        if (this.classifier == null) {
            return String.format("%s%s%s%s%s%s%s", this.groupId, GAV_SPLIT, this.artifactId, GAV_SPLIT, this.version, GAV_SPLIT, this.type);
        }
        return String.format("%s%s%s%s%s%s%s%s%s", this.groupId, GAV_SPLIT, this.artifactId, GAV_SPLIT, this.classifier, GAV_SPLIT, this.version, GAV_SPLIT, this.type);
    }

    public boolean isSameIgnoreVersion(ArtifactItem that) {
        if (that == null) {
            return false;
        }
        return this.isSameStr(this.getGroupId(), that.getGroupId()) && this.isSameStr(this.getArtifactId(), that.getArtifactId()) && this.isSameStr(this.getClassifier(), that.getClassifier());
    }

    public boolean isSameWithVersion(ArtifactItem that) {
        if (that == null) {
            return false;
        }
        return this.isSameStr(this.getGroupId(), that.getGroupId()) && this.isSameStr(this.getArtifactId(), that.getArtifactId()) && this.isSameStr(this.getVersion(), that.getVersion()) && this.isSameStr(this.getClassifier(), that.getClassifier());
    }

    protected boolean isSameStr(String left, String right) {
        if ("*".equals(left) || "*".equals(right)) {
            return true;
        }
        return StringUtils.isSameStr((String)left, (String)right);
    }

    public static ArtifactItem parseArtifactItemIgnoreVersion(String s) {
        String[] arr = new String[]{};
        if (s != null && !s.isEmpty()) {
            arr = s.split(GAV_SPLIT);
        }
        AssertUtils.isTrue((arr != null && arr.length >= 2 && arr.length <= 3 ? 1 : 0) != 0, (String)"artifact item format error: %s", (Object[])new Object[]{s});
        ArtifactItem item = new ArtifactItem();
        item.setGroupId(arr[0]);
        item.setArtifactId(arr[1]);
        if (arr.length == 3) {
            item.setClassifier(arr[2]);
        }
        return item;
    }

    public static ArtifactItem parseArtifactItemWithVersion(String s) {
        String[] arr = new String[]{};
        if (s != null && !s.isEmpty()) {
            arr = s.split(GAV_SPLIT);
        }
        AssertUtils.isTrue((arr != null && arr.length >= 3 && arr.length <= 4 ? 1 : 0) != 0, (String)"artifact item format error: %s", (Object[])new Object[]{s});
        ArtifactItem item = new ArtifactItem();
        item.setGroupId(arr[0]);
        item.setArtifactId(arr[1]);
        item.setVersion(arr[2]);
        if (arr.length == 4) {
            item.setClassifier(arr[3]);
        }
        return item;
    }

    public static ArtifactItem parseArtifactItem(Artifact artifact) {
        ArtifactItem artifactItem = new ArtifactItem();
        artifactItem.setGroupId(artifact.getGroupId());
        artifactItem.setArtifactId(artifact.getArtifactId());
        artifactItem.setClassifier(artifact.getClassifier());
        artifactItem.setVersion(artifact.getVersion());
        artifactItem.setType(artifact.getType());
        artifactItem.setScope(artifact.getScope());
        return artifactItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactItem artifactItem = (ArtifactItem)o;
        return Objects.equals(this.groupId, artifactItem.getGroupId()) && Objects.equals(this.artifactId, artifactItem.getArtifactId()) && Objects.equals(this.type, artifactItem.getType()) && Objects.equals(this.version, artifactItem.getVersion()) && Objects.equals(this.classifier, artifactItem.getClassifier()) && Objects.equals(this.scope, artifactItem.getScope());
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.type, this.version, this.classifier);
    }
}

