/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.tools;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.tools.ArtifactItem;
import com.alipay.sofa.ark.tools.JarWriter;
import com.alipay.sofa.ark.tools.Layout;
import com.alipay.sofa.ark.tools.Layouts;
import com.alipay.sofa.ark.tools.Libraries;
import com.alipay.sofa.ark.tools.Library;
import com.alipay.sofa.ark.tools.LibraryCallback;
import com.alipay.sofa.ark.tools.LibraryScope;
import com.alipay.sofa.ark.tools.MainClassFinder;
import com.alipay.sofa.ark.tools.git.GitInfo;
import com.alipay.sofa.ark.tools.git.JGitParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Repackager {
    private static final String ARK_VERSION_ATTRIBUTE = "Sofa-Ark-Version";
    private static final String ARK_CONTAINER_ROOT = "Ark-Container-Root";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private List<MainClassTimeoutWarningListener> mainClassTimeoutListeners = new ArrayList<MainClassTimeoutWarningListener>();
    private String mainClass;
    private String bizName;
    private String bizVersion;
    private String priority;
    private LinkedHashSet<String> denyImportPackages;
    private LinkedHashSet<String> denyImportClasses;
    private LinkedHashSet<String> denyImportResources;
    private LinkedHashSet<ArtifactItem> injectPluginDependencies = new LinkedHashSet();
    private LinkedHashSet<String> injectPluginExportPackages = new LinkedHashSet();
    private LinkedHashSet<String> declaredLibraries = new LinkedHashSet();
    private final File source;
    private File executableFatJar;
    private File pluginModuleJar;
    private File baseDir;
    private boolean packageProvided;
    private boolean skipArkExecutable;
    private boolean keepArkBizJar;
    private String webContextPath;
    private boolean declaredMode;
    private String arkVersion = null;
    private Library arkContainerLibrary = null;
    private final List<Library> standardLibraries = new ArrayList<Library>();
    private final List<Library> arkPluginLibraries = new ArrayList<Library>();
    private final List<Library> arkModuleLibraries = new ArrayList<Library>();
    private File gitDirectory;
    private GitInfo gitInfo;

    public Repackager(File source) {
        if (source == null) {
            throw new IllegalArgumentException("Source file must be provided");
        }
        if (!source.exists() || !source.isFile()) {
            throw new IllegalArgumentException("Source must refer to an existing file, got" + source.getAbsolutePath());
        }
        this.source = source.getAbsoluteFile();
    }

    public void addMainClassTimeoutWarningListener(MainClassTimeoutWarningListener listener) {
        this.mainClassTimeoutListeners.add(listener);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setBizName(String bizName) {
        this.bizName = bizName;
    }

    public void setBizVersion(String bizVersion) {
        this.bizVersion = bizVersion;
    }

    public void setArkVersion(String arkVersion) {
        this.arkVersion = arkVersion;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setDenyImportPackages(LinkedHashSet<String> denyImportPackages) {
        this.denyImportPackages = denyImportPackages;
    }

    public void setDenyImportClasses(LinkedHashSet<String> denyImportClasses) {
        this.denyImportClasses = denyImportClasses;
    }

    public void setDenyImportResources(LinkedHashSet<String> denyImportResources) {
        this.denyImportResources = denyImportResources;
    }

    public void setInjectPluginExportPackages(LinkedHashSet<String> injectPluginExportPackages) {
        this.injectPluginExportPackages = injectPluginExportPackages;
    }

    public void setInjectPluginDependencies(LinkedHashSet<String> injectPluginDependencies) {
        if (injectPluginDependencies == null) {
            return;
        }
        for (String artifact : injectPluginDependencies) {
            ArtifactItem item = new ArtifactItem();
            String[] artifactWithVersion = artifact.split(":");
            AssertUtils.isFalse((artifactWithVersion.length != 2 ? 1 : 0) != 0, (String)("injectPluginDependencies item must be follow format by name:version, current is:" + artifact), (Object[])new Object[0]);
            item.setArtifactId(artifactWithVersion[0]);
            item.setVersion(artifactWithVersion[1]);
            this.injectPluginDependencies.add(item);
        }
    }

    public void setGitDirectory(File gitDirectory) {
        this.gitDirectory = gitDirectory;
    }

    public void prepareDeclaredLibraries(Collection<ArtifactItem> artifactItems) {
        if (!this.declaredMode) {
            return;
        }
        if (artifactItems == null) {
            return;
        }
        for (ArtifactItem artifactItem : artifactItems) {
            if (artifactItem == null || artifactItem.getArtifactId() == null) continue;
            this.declaredLibraries.add(artifactItem.getArtifactId());
        }
    }

    public void repackage(File appDestination, File moduleDestination, Libraries libraries) throws IOException {
        if (appDestination == null || appDestination.isDirectory() || moduleDestination == null || moduleDestination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination");
        }
        if (libraries == null) {
            throw new IllegalArgumentException("Libraries must not be null");
        }
        if (this.alreadyRepackaged()) {
            return;
        }
        this.executableFatJar = appDestination;
        this.pluginModuleJar = moduleDestination;
        libraries.doWithLibraries(new LibraryCallback(){

            @Override
            public void library(Library library) throws IOException {
                if (LibraryScope.PROVIDED.equals(library.getScope()) && !Repackager.this.isPackageProvided()) {
                    return;
                }
                if (!Repackager.isZip(library.getFile())) {
                    return;
                }
                try (JarFile jarFile = new JarFile(library.getFile());){
                    if (Repackager.this.isArkContainer(jarFile)) {
                        if (Repackager.this.arkContainerLibrary != null) {
                            throw new RuntimeException("duplicate SOFAArk Container dependency");
                        }
                        library.setScope(LibraryScope.CONTAINER);
                        Repackager.this.arkContainerLibrary = library;
                    } else if (Repackager.this.isArkModule(jarFile)) {
                        library.setScope(LibraryScope.MODULE);
                        Repackager.this.arkModuleLibraries.add(library);
                    } else if (Repackager.this.isArkPlugin(jarFile)) {
                        library.setScope(LibraryScope.PLUGIN);
                        Repackager.this.arkPluginLibraries.add(library);
                    } else {
                        Repackager.this.standardLibraries.add(library);
                    }
                }
            }
        });
        this.gitInfo = JGitParser.parse(this.gitDirectory);
        this.repackageModule();
        this.repackageApp();
        this.removeArkBizJar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repackageModule() throws IOException {
        File destination = this.pluginModuleJar.getAbsoluteFile();
        destination.delete();
        JarFile jarFileSource = new JarFile(this.source);
        JarWriter writer = new JarWriter(destination);
        Manifest manifest = this.buildModuleManifest(jarFileSource);
        try {
            writer.writeManifest(manifest);
            this.writeConfDir(new File(this.baseDir, "conf/"), writer);
            writer.writeEntries(jarFileSource);
            writer.writeMarkEntry();
            this.writeNestedLibraries(this.standardLibraries, Layouts.Module.module(), writer);
        }
        finally {
            jarFileSource.close();
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private List<Library> getModuleLibraries() {
        ArrayList<Library> libraries = new ArrayList<Library>(this.arkModuleLibraries);
        Library moduleLibrary = new Library(this.pluginModuleJar.getAbsoluteFile(), LibraryScope.MODULE);
        libraries.add(moduleLibrary);
        return libraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repackageApp() throws IOException {
        if (this.skipArkExecutable) {
            return;
        }
        File destination = this.executableFatJar.getAbsoluteFile();
        destination.delete();
        JarFile jarFileSource = new JarFile(this.arkContainerLibrary.getFile().getAbsoluteFile());
        JarWriter writer = new JarWriter(destination);
        Manifest manifest = this.buildAppManifest(new JarFile(this.pluginModuleJar));
        try {
            writer.writeManifest(manifest);
            this.writeConfDir(new File(this.baseDir, "conf/"), writer);
            writer.writeBootstrapEntry(jarFileSource);
            this.writeNestedLibraries(Collections.singletonList(this.arkContainerLibrary), Layouts.Jar.jar(), writer);
            this.writeNestedLibraries(this.arkPluginLibraries, Layouts.Jar.jar(), writer);
            this.writeNestedLibraries(this.getModuleLibraries(), Layouts.Jar.jar(), writer);
        }
        finally {
            jarFileSource.close();
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void removeArkBizJar() {
        if (!this.keepArkBizJar) {
            this.pluginModuleJar.getAbsoluteFile().deleteOnExit();
        }
    }

    private void writeConfDir(File confDir, JarWriter jarWriter) throws IOException {
        if (!confDir.exists()) {
            return;
        }
        for (File subFile : confDir.listFiles()) {
            if (subFile.isDirectory()) {
                this.writeConfDir(subFile, jarWriter);
                continue;
            }
            String entryName = subFile.getPath().substring(this.baseDir.getPath().length());
            if (entryName.startsWith(File.separator)) {
                entryName = entryName.substring(1);
            }
            jarWriter.writeEntry(FileUtils.getCompatiblePath((String)entryName), new FileInputStream(subFile));
        }
    }

    private void writeNestedLibraries(List<Library> libraries, Layout layout, JarWriter writer) throws IOException {
        HashSet<String> alreadySeen = new HashSet<String>();
        for (Library library : libraries) {
            String destination = layout.getLibraryDestination(library.getName(), library.getScope());
            if (destination == null) continue;
            if (!alreadySeen.add(destination + library.getName())) {
                throw new IllegalStateException("Duplicate library " + library.getName());
            }
            boolean isWrite = false;
            for (ArtifactItem item : this.injectPluginDependencies) {
                if (!library.getName().equals(item.getArtifactId() + "-" + item.getVersion() + ".jar")) continue;
                writer.writeNestedLibrary(destination + "export/", library);
                isWrite = true;
                break;
            }
            if (isWrite) continue;
            writer.writeNestedLibrary(destination, library);
        }
    }

    public static boolean isZip(File file) {
        boolean bl;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = Repackager.isZip(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    private boolean isArkContainer(JarFile jarFile) {
        return jarFile.getEntry("com/alipay/sofa/ark/container/mark") != null;
    }

    private boolean isArkPlugin(JarFile jarFile) {
        return jarFile.getEntry("com/alipay/sofa/ark/plugin/mark") != null;
    }

    private boolean isArkModule(JarFile jarFile) {
        return jarFile.getEntry("com/alipay/sofa/ark/biz/mark") != null;
    }

    public static boolean isZip(InputStream inputStream) throws IOException {
        for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
            if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    public Manifest buildModuleManifest(JarFile source) throws IOException {
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        manifest = new Manifest(manifest);
        String startClass = this.mainClass;
        if (startClass == null) {
            startClass = manifest.getMainAttributes().getValue("Main-Class");
        }
        if (startClass == null) {
            startClass = this.findMainMethodWithTimeoutWarning(source);
        }
        if (startClass == null) {
            throw new IllegalStateException("Unable to find main class.");
        }
        manifest.getMainAttributes().putValue("Main-Class", startClass);
        manifest.getMainAttributes().putValue("Start-Class", startClass);
        manifest.getMainAttributes().putValue("Ark-Biz-Name", this.bizName);
        manifest.getMainAttributes().putValue("Ark-Biz-Version", this.bizVersion);
        manifest.getMainAttributes().putValue("priority", this.priority);
        manifest.getMainAttributes().putValue("web-context-path", this.webContextPath);
        manifest.getMainAttributes().putValue("deny-import-packages", StringUtils.setToStr(this.denyImportPackages, (String)","));
        manifest.getMainAttributes().putValue("deny-import-classes", StringUtils.setToStr(this.denyImportClasses, (String)","));
        manifest.getMainAttributes().putValue("deny-import-resources", StringUtils.setToStr(this.denyImportResources, (String)","));
        manifest.getMainAttributes().putValue("inject-plugin-dependencies", Repackager.setToStr(this.injectPluginDependencies, ","));
        manifest.getMainAttributes().putValue("inject-export-packages", StringUtils.setToStr(this.injectPluginExportPackages, (String)","));
        manifest.getMainAttributes().putValue("declared-libraries", StringUtils.setToStr(this.declaredLibraries, (String)","));
        return this.appendBuildInfo(manifest);
    }

    public static String setToStr(Set<ArtifactItem> artifactItemSet, String delimiter) {
        if (artifactItemSet == null || artifactItemSet.isEmpty()) {
            return "";
        }
        AssertUtils.assertNotNull((Object)delimiter, (String)"Delimiter should not be null.");
        StringBuilder sb = new StringBuilder();
        for (ArtifactItem item : artifactItemSet) {
            sb.append(item.getArtifactId()).append("-").append(item.getVersion()).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    private Manifest buildAppManifest(JarFile source) throws IOException {
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        manifest = new Manifest(manifest);
        manifest.getMainAttributes().putValue("Main-Class", Layouts.Jar.jar().getLauncherClassName());
        manifest.getMainAttributes().putValue("Start-Class", Layouts.Jar.jar().getLauncherClassName());
        if (this.arkVersion == null || this.arkVersion.isEmpty()) {
            throw new IllegalStateException("must specify version of SOFAArk.");
        }
        manifest.getMainAttributes().putValue(ARK_VERSION_ATTRIBUTE, this.arkVersion);
        manifest.getMainAttributes().putValue(ARK_CONTAINER_ROOT, Layouts.Jar.jar().getArkContainerLocation());
        return this.appendBuildInfo(manifest);
    }

    private Manifest appendBuildInfo(Manifest manifest) {
        manifest.getMainAttributes().putValue("build-time", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date()));
        if (this.gitInfo != null) {
            manifest.getMainAttributes().putValue("remote-origin-url", this.gitInfo.getRepository());
            manifest.getMainAttributes().putValue("commit-branch", this.gitInfo.getBranchName());
            manifest.getMainAttributes().putValue("commit-id", this.gitInfo.getLastCommitId());
            manifest.getMainAttributes().putValue("commit-user-name", this.gitInfo.getLastCommitUser());
            manifest.getMainAttributes().putValue("commit-user-email", this.gitInfo.getLastCommitEmail());
            manifest.getMainAttributes().putValue("commit-time", this.gitInfo.getLastCommitDateTime());
            manifest.getMainAttributes().putValue("commit-timestamp", String.valueOf(this.gitInfo.getLastCommitTime()));
            manifest.getMainAttributes().putValue("build-user", this.gitInfo.getBuildUser());
            manifest.getMainAttributes().putValue("build-email", this.gitInfo.getBuildEmail());
        }
        return manifest;
    }

    public String findMainMethodWithTimeoutWarning(JarFile source) throws IOException {
        long startTime = System.currentTimeMillis();
        String mainMethod = this.findMainMethod(source);
        long duration = System.currentTimeMillis() - startTime;
        if (duration > FIND_WARNING_TIMEOUT) {
            for (MainClassTimeoutWarningListener listener : this.mainClassTimeoutListeners) {
                listener.handleTimeoutWarning(duration, mainMethod);
            }
        }
        return mainMethod;
    }

    private String findMainMethod(JarFile source) throws IOException {
        return MainClassFinder.findSingleMainClass(source, null, SPRING_BOOT_APPLICATION_CLASS_NAME);
    }

    private boolean alreadyRepackaged() throws IOException {
        try (JarFile jarFile = new JarFile(this.source);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue(ARK_VERSION_ATTRIBUTE) != null;
            return bl;
        }
    }

    public final File getModuleTargetFile() {
        return this.pluginModuleJar;
    }

    public boolean isPackageProvided() {
        return this.packageProvided;
    }

    public void setPackageProvided(boolean packageProvided) {
        this.packageProvided = packageProvided;
    }

    public void setSkipArkExecutable(boolean skipArkExecutable) {
        this.skipArkExecutable = skipArkExecutable;
    }

    public void setKeepArkBizJar(boolean keepArkBizJar) {
        this.keepArkBizJar = keepArkBizJar;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setWebContextPath(String webContextPath) {
        this.webContextPath = webContextPath;
    }

    public void setDeclaredMode(boolean declaredMode) {
        this.declaredMode = declaredMode;
    }

    public boolean isDeclaredMode() {
        return this.declaredMode;
    }

    static final class RenamingEntryTransformer
    implements JarWriter.EntryTransformer {
        private final String namePrefix;

        RenamingEntryTransformer(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public JarEntry transform(JarEntry entry) {
            JarEntry renamedEntry = new JarEntry(this.namePrefix + entry.getName());
            renamedEntry.setTime(entry.getTime());
            renamedEntry.setSize(entry.getSize());
            renamedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                renamedEntry.setComment(entry.getComment());
            }
            renamedEntry.setCompressedSize(entry.getCompressedSize());
            renamedEntry.setCrc(entry.getCrc());
            if (entry.getExtra() != null) {
                renamedEntry.setExtra(entry.getExtra());
            }
            return renamedEntry;
        }
    }

    public static interface MainClassTimeoutWarningListener {
        public void handleTimeoutWarning(long var1, String var3);
    }
}

