/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.tools.git;

import com.alipay.sofa.ark.tools.git.GitInfo;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class JGitParser {
    public static final Comparator<String> MASTER_FIRST_COMPARATOR = (o1, o2) -> "master".equals(o1) ? -1 : 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GitInfo parse(File gitDirectory) {
        try (FileRepository repository = JGitParser.getGitRepository(gitDirectory);){
            GitInfo gitInfo2 = new GitInfo();
            FileBasedConfig config = repository.getConfig();
            String remoteUrl = config.getString("remote", "origin", "url");
            String userName = config.getString("user", null, "name");
            String userEmail = config.getString("user", null, "email");
            String branchName = repository.getBranch();
            gitInfo2.setRepository(remoteUrl);
            gitInfo2.setBuildUser(userName);
            gitInfo2.setBuildEmail(userEmail);
            gitInfo2.setBranchName(branchName);
            RevCommit lastCommit = JGitParser.getLastCommit((Repository)repository);
            if (lastCommit != null) {
                String lastCommitId = lastCommit.getId().getName();
                long lastCommitTime = lastCommit.getCommitterIdent().getWhen().getTime();
                String lastCommitUser = lastCommit.getAuthorIdent().getName();
                String lastCommitEmail = lastCommit.getAuthorIdent().getEmailAddress();
                String commitDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(lastCommitTime);
                gitInfo2.setLastCommitId(lastCommitId);
                gitInfo2.setLastCommitUser(lastCommitUser);
                gitInfo2.setLastCommitEmail(lastCommitEmail);
                gitInfo2.setLastCommitTime(lastCommitTime);
                gitInfo2.setLastCommitDateTime(commitDateTime);
                if (lastCommitId.equals(branchName)) {
                    gitInfo2.setBranchName(StringUtils.join(JGitParser.getBranchesFromCommit(repository, lastCommitId), (String)","));
                }
            }
            GitInfo gitInfo = gitInfo2;
            return gitInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static List<String> getBranchesFromCommit(FileRepository repository, String lastCommitId) throws GitAPIException {
        List refs = Git.wrap((Repository)repository).branchList().setListMode(ListBranchCommand.ListMode.REMOTE).setContains(lastCommitId).call();
        return refs.stream().filter(ref -> !ref.isSymbolic()).map(Ref::getName).map(arg_0 -> ((FileRepository)repository).shortenRemoteBranchName(arg_0)).filter(StringUtils::isNotBlank).distinct().sorted(MASTER_FIRST_COMPARATOR).collect(Collectors.toList());
    }

    private static RevCommit getLastCommit(Repository repository) throws Exception {
        RevWalk revWalk = new RevWalk(repository);
        Ref headCommitReference = repository.getRefDatabase().findRef("HEAD");
        ObjectId headObjectId = headCommitReference != null ? headCommitReference.getObjectId() : repository.resolve("HEAD");
        if (headObjectId == null) {
            throw new Exception("Could not get HEAD Ref, are you sure have commits in the gitDirectory?");
        }
        RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headObjectId);
        revWalk.markStart(headCommit);
        return headCommit;
    }

    private static FileRepository getGitRepository(File gitDirectory) throws Exception {
        Repository repository;
        if (gitDirectory == null || !gitDirectory.exists()) {
            throw new Exception("Could not create git repository. " + gitDirectory + " is not exists!");
        }
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new Exception("Could not initialize git repository...", e);
        }
        if (repository == null) {
            throw new Exception("Could not create git repository. Are you sure '" + gitDirectory + "' is the valid Git root for your project?");
        }
        return (FileRepository)repository;
    }
}

