/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.autoconfigure.health;

import com.alipay.sofa.boot.actuator.autoconfigure.health.SofaHttpCodeStatusMapper;
import com.alipay.sofa.boot.actuator.health.ManualReadinessCallbackEndPoint;
import com.alipay.sofa.boot.actuator.health.MultiApplicationHealthIndicator;
import com.alipay.sofa.boot.actuator.health.ReadinessEndpointWebExtension;
import com.alipay.sofa.boot.actuator.health.SofaBootHealthIndicator;
import com.alipay.sofa.boot.actuator.health.SofaBootReadinessEndpoint;
import com.alipay.sofa.healthcheck.AfterReadinessCheckCallbackProcessor;
import com.alipay.sofa.healthcheck.HealthCheckProperties;
import com.alipay.sofa.healthcheck.HealthCheckerProcessor;
import com.alipay.sofa.healthcheck.HealthIndicatorProcessor;
import com.alipay.sofa.healthcheck.ReadinessCheckListener;
import com.alipay.sofa.healthcheck.core.HealthCheckExecutor;
import com.alipay.sofa.healthcheck.core.HealthChecker;
import com.alipay.sofa.healthcheck.impl.ComponentHealthChecker;
import com.alipay.sofa.healthcheck.impl.ModuleHealthChecker;
import com.alipay.sofa.healthcheck.impl.SofaRuntimeHealthChecker;
import com.alipay.sofa.isle.stage.ModelCreatingStage;
import com.alipay.sofa.runtime.configure.SofaRuntimeConfigurationProperties;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HealthCheckProperties.class})
@ConditionalOnClass(value={HealthChecker.class})
public class SofaBootHealthCheckAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ReadinessCheckListener readinessCheckListener(Environment environment, HealthCheckerProcessor healthCheckerProcessor, HealthIndicatorProcessor healthIndicatorProcessor, AfterReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor, SofaRuntimeConfigurationProperties sofaRuntimeConfigurationProperties, HealthCheckProperties healthCheckProperties) {
        return new ReadinessCheckListener(environment, healthCheckerProcessor, healthIndicatorProcessor, afterReadinessCheckCallbackProcessor, sofaRuntimeConfigurationProperties, healthCheckProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint(endpoint=ManualReadinessCallbackEndPoint.class)
    @ConditionalOnProperty(prefix="com.alipay.sofa.boot", name={"manualReadinessCallback"}, havingValue="true")
    public ManualReadinessCallbackEndPoint manualReadinessCallbackEndPoint(ReadinessCheckListener readinessCheckListener) {
        return new ManualReadinessCallbackEndPoint(readinessCheckListener);
    }

    @Bean
    public HealthCheckerProcessor healthCheckerProcessor(HealthCheckProperties healthCheckProperties, HealthCheckExecutor healthCheckExecutor) {
        return new HealthCheckerProcessor(healthCheckProperties, healthCheckExecutor);
    }

    @Bean
    public HealthIndicatorProcessor healthIndicatorProcessor(HealthCheckProperties properties, HealthCheckExecutor healthCheckExecutor) {
        return new HealthIndicatorProcessor(properties, healthCheckExecutor);
    }

    @Bean
    public AfterReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor() {
        return new AfterReadinessCheckCallbackProcessor();
    }

    @Bean
    public SofaBootHealthIndicator sofaBootHealthIndicator(HealthCheckerProcessor healthCheckerProcessor, ReadinessCheckListener readinessCheckListener) {
        return new SofaBootHealthIndicator(healthCheckerProcessor, readinessCheckListener);
    }

    @Bean
    public SofaRuntimeHealthChecker defaultRuntimeHealthChecker(SofaRuntimeContext sofaRuntimeContext, List<HealthIndicator> healthIndicators, ReadinessCheckListener readinessCheckListener) {
        return new SofaRuntimeHealthChecker(sofaRuntimeContext, healthIndicators, readinessCheckListener);
    }

    @Bean
    @ConditionalOnClass(name={"com.alipay.sofa.ark.spi.model.Biz"})
    public MultiApplicationHealthIndicator multiApplicationHealthIndicator() {
        return new MultiApplicationHealthIndicator();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint(endpoint=SofaBootReadinessEndpoint.class)
    public SofaBootReadinessEndpoint sofaBootReadinessCheckEndpoint(ReadinessCheckListener readinessCheckListener) {
        return new SofaBootReadinessEndpoint(readinessCheckListener);
    }

    @Bean
    public ComponentHealthChecker sofaComponentHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        return new ComponentHealthChecker(sofaRuntimeContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthCheckExecutor healthCheckExecutor(HealthCheckProperties properties) {
        return new HealthCheckExecutor(properties);
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureBefore(value={HealthEndpointAutoConfiguration.class})
    @ConditionalOnClass(value={HealthChecker.class})
    public static class ReadinessCheckExtensionConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnAvailableEndpoint(endpoint=ReadinessEndpointWebExtension.class)
        public ReadinessEndpointWebExtension readinessEndpointWebExtension(SofaBootReadinessEndpoint delegate, HttpCodeStatusMapper statusMapper) {
            return new ReadinessEndpointWebExtension(delegate, statusMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        public HttpCodeStatusMapper httpCodeStatusMapper(HealthEndpointProperties healthEndpointProperties) {
            return new SofaHttpCodeStatusMapper(healthEndpointProperties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HealthChecker.class, ModelCreatingStage.class})
    @ConditionalOnProperty(value={"com.alipay.sofa.boot.enable-isle"}, matchIfMissing=true)
    public static class SofaModuleHealthIndicatorConfiguration {
        @Bean
        public ModuleHealthChecker sofaModuleHealthChecker() {
            return new ModuleHealthChecker();
        }
    }
}

