/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.beans;

import com.alipay.sofa.boot.isle.ApplicationRuntimeModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.beans.BeansEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class IsleBeansEndpoint
extends BeansEndpoint {
    private final ApplicationRuntimeModel applicationRuntimeModel;

    public IsleBeansEndpoint(ConfigurableApplicationContext context, ApplicationRuntimeModel applicationRuntimeModel) {
        super(context);
        this.applicationRuntimeModel = applicationRuntimeModel;
    }

    @ReadOperation
    public BeansEndpoint.BeansDescriptor beans() {
        BeansEndpoint.BeansDescriptor beansDescriptor = super.beans();
        String springParentId = null;
        for (Map.Entry entry : beansDescriptor.getContexts().entrySet()) {
            if (((BeansEndpoint.ContextBeansDescriptor)entry.getValue()).getParentId() != null) continue;
            springParentId = (String)entry.getKey();
            break;
        }
        Map<String, BeansEndpoint.ContextBeansDescriptor> moduleApplicationContexts = this.getModuleApplicationContexts(this.applicationRuntimeModel, springParentId);
        beansDescriptor.getContexts().putAll(moduleApplicationContexts);
        return beansDescriptor;
    }

    private Map<String, BeansEndpoint.ContextBeansDescriptor> getModuleApplicationContexts(ApplicationRuntimeModel applicationRuntimeModel, String springParentId) {
        HashMap<String, BeansEndpoint.ContextBeansDescriptor> contexts = new HashMap<String, BeansEndpoint.ContextBeansDescriptor>();
        List installedModules = applicationRuntimeModel.getInstalled();
        installedModules.forEach(descriptor -> {
            BeansEndpoint.ContextBeansDescriptor contextBeans;
            ApplicationContext applicationContext = descriptor.getApplicationContext();
            String parentId = descriptor.getSpringParent();
            if (parentId == null) {
                parentId = springParentId;
            }
            if (applicationContext instanceof ConfigurableApplicationContext && (contextBeans = this.describing((ConfigurableApplicationContext)applicationContext, parentId)) != null) {
                contexts.put(descriptor.getModuleName(), contextBeans);
            }
        });
        return contexts;
    }

    private BeansEndpoint.ContextBeansDescriptor describing(ConfigurableApplicationContext context, String parentModuleName) {
        Map<String, BeansEndpoint.BeanDescriptor> beanDescriptorMap = this.callContextBeansDescribeBeans(context.getBeanFactory());
        return this.createContextBeans(beanDescriptorMap, parentModuleName);
    }

    private Map<String, BeansEndpoint.BeanDescriptor> callContextBeansDescribeBeans(ConfigurableListableBeanFactory beanFactory) {
        try {
            Class<BeansEndpoint.ContextBeansDescriptor> clazz = BeansEndpoint.ContextBeansDescriptor.class;
            Method method = clazz.getDeclaredMethod("describeBeans", ConfigurableListableBeanFactory.class);
            method.setAccessible(true);
            Object result = method.invoke(null, beanFactory);
            return (Map)result;
        }
        catch (Throwable e) {
            return new HashMap<String, BeansEndpoint.BeanDescriptor>();
        }
    }

    private BeansEndpoint.ContextBeansDescriptor createContextBeans(Map<String, BeansEndpoint.BeanDescriptor> beans, String parentId) {
        try {
            Class<BeansEndpoint.ContextBeansDescriptor> clazz = BeansEndpoint.ContextBeansDescriptor.class;
            Constructor constructor = clazz.getDeclaredConstructor(Map.class, String.class);
            constructor.setAccessible(true);
            return (BeansEndpoint.ContextBeansDescriptor)constructor.newInstance(beans, parentId);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

