/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.components;

import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="components")
public class ComponentsEndpoint {
    private final SofaRuntimeContext sofaRuntimeContext;

    public ComponentsEndpoint(SofaRuntimeContext sofaRuntimeContext) {
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    @ReadOperation
    public ComponentsDescriptor components() {
        ComponentManager componentManager = this.sofaRuntimeContext.getComponentManager();
        HashMap<String, Collection<ComponentDisplayInfo>> componentsInfoMap = new HashMap<String, Collection<ComponentDisplayInfo>>();
        Collection componentTypes = componentManager.getComponentTypes();
        componentTypes.forEach(componentType -> {
            Collection componentInfos = componentManager.getComponentInfosByType(componentType);
            Collection componentDisplayInfos = componentInfos.stream().map(componentInfo -> {
                String applicationId = componentInfo.getApplicationContext() == null ? "null" : componentInfo.getApplicationContext().getId();
                Map propertyMap = componentInfo.getProperties();
                return new ComponentDisplayInfo(componentInfo.getName().getName(), applicationId, propertyMap != null ? propertyMap.values().stream().map(PropertyInfo::new).collect(Collectors.toList()) : null);
            }).collect(Collectors.toList());
            componentsInfoMap.put(componentType.getName(), componentDisplayInfos);
        });
        return new ComponentsDescriptor(componentsInfoMap);
    }

    public static final class ComponentsDescriptor
    implements OperationResponseBody {
        private final Map<String, Collection<ComponentDisplayInfo>> componentsInfoMap;

        private ComponentsDescriptor(Map<String, Collection<ComponentDisplayInfo>> componentsInfoMap) {
            this.componentsInfoMap = componentsInfoMap;
        }

        public Map<String, Collection<ComponentDisplayInfo>> getComponentsInfoMap() {
            return this.componentsInfoMap;
        }
    }

    public static final class ComponentDisplayInfo {
        private final String name;
        private final String applicationId;
        private List<PropertyInfo> properties;

        private ComponentDisplayInfo(String name, String applicationId, List<PropertyInfo> properties) {
            this.name = name;
            this.applicationId = applicationId;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public List<PropertyInfo> getProperties() {
            return this.properties;
        }
    }

    public static final class PropertyInfo {
        private String name;
        private Object value;

        public PropertyInfo(Property property) {
            this.name = property.getName();
            this.value = property.getValue();
        }

        public PropertyInfo(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

