/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import com.alipay.sofa.boot.actuator.health.HealthChecker;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.util.StringUtils;

public class ComponentHealthChecker
implements HealthChecker {
    public static final String COMPONENT_NAME = "components";
    private final SofaRuntimeContext sofaRuntimeContext;

    public ComponentHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    @Override
    public Health isHealthy() {
        boolean allPassed = true;
        Health.Builder builder = new Health.Builder();
        for (ComponentInfo componentInfo : this.sofaRuntimeContext.getComponentManager().getComponents()) {
            HealthResult healthy = componentInfo.isHealthy();
            String healthReport = healthy.getHealthReport();
            if (healthy.isHealthy()) continue;
            allPassed = false;
            builder.withDetail(healthy.getHealthName(), (Object)(StringUtils.hasText((String)healthReport) ? healthReport : "failed"));
        }
        if (allPassed) {
            return builder.status(Status.UP).build();
        }
        return builder.status(Status.DOWN).build();
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public int getRetryCount() {
        return 20;
    }

    @Override
    public long getRetryTimeInterval() {
        return 1000L;
    }

    @Override
    public boolean isStrictCheck() {
        return true;
    }

    @Override
    public int getTimeout() {
        return 10000;
    }
}

