/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import com.alipay.sofa.boot.actuator.health.HealthCheckComparatorSupport;
import com.alipay.sofa.boot.actuator.health.HealthChecker;
import com.alipay.sofa.boot.actuator.health.HealthCheckerConfig;
import com.alipay.sofa.boot.actuator.health.NonReadinessCheck;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.startup.BaseStat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class HealthCheckerProcessor
implements ApplicationContextAware {
    private static final Logger logger = SofaBootLoggerFactory.getLogger(HealthCheckerProcessor.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AtomicBoolean isInitiated = new AtomicBoolean(false);
    private final List<BaseStat> healthCheckerStartupStatList = new CopyOnWriteArrayList<BaseStat>();
    private ExecutorService healthCheckExecutor;
    private ApplicationContext applicationContext;
    private LinkedHashMap<String, HealthChecker> healthCheckers = new LinkedHashMap();
    private int globalTimeout;
    private Map<String, HealthCheckerConfig> healthCheckerConfigs;
    private boolean parallelCheck;
    private long parallelCheckTimeout;

    public void init() {
        if (this.isInitiated.compareAndSet(false, true)) {
            Assert.notNull((Object)this.applicationContext, () -> "Application must not be null");
            Assert.notNull((Object)this.healthCheckExecutor, () -> "HealthCheckExecutor must not be null");
            Map beansOfType = this.applicationContext.getBeansOfType(HealthChecker.class);
            this.healthCheckers = HealthCheckComparatorSupport.sortMapAccordingToValue(beansOfType, HealthCheckComparatorSupport.getComparatorToUse((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory()));
            String healthCheckInfo = "Found " + this.healthCheckers.size() + " HealthChecker implementation:" + String.join((CharSequence)",", this.healthCheckers.keySet());
            logger.info(healthCheckInfo);
        }
    }

    public boolean readinessHealthCheck(Map<String, Health> healthMap) {
        boolean result;
        Assert.notNull(this.healthCheckers, (String)"HealthCheckers must not be null.");
        logger.info("Begin SOFABoot HealthChecker readiness check.");
        Map<String, HealthChecker> readinessHealthCheckers = this.healthCheckers.entrySet().stream().filter(entry -> !(entry.getValue() instanceof NonReadinessCheck)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String checkComponentNames = readinessHealthCheckers.values().stream().map(HealthChecker::getComponentName).collect(Collectors.joining(","));
        logger.info("SOFABoot HealthChecker readiness check {} item: {}.", (Object)readinessHealthCheckers.size(), (Object)checkComponentNames);
        if (this.isParallelCheck()) {
            CountDownLatch countDownLatch = new CountDownLatch(readinessHealthCheckers.size());
            AtomicBoolean parallelResult = new AtomicBoolean(true);
            readinessHealthCheckers.forEach((key, value) -> this.healthCheckExecutor.execute(new AsyncHealthCheckRunnable((String)key, (HealthChecker)value, healthMap, parallelResult, countDownLatch)));
            boolean finished = false;
            try {
                finished = countDownLatch.await(this.getParallelCheckTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error(ErrorCode.convert((String)"01-22005"), (Throwable)e);
            }
            if (!finished) {
                parallelResult.set(false);
                healthMap.put("parallelCheck", new Health.Builder().withDetail("timeout", (Object)this.getParallelCheckTimeout()).status(Status.UNKNOWN).build());
            }
            result = finished && parallelResult.get();
        } else {
            result = readinessHealthCheckers.entrySet().stream().map(entry -> this.doHealthCheck((String)entry.getKey(), (HealthChecker)entry.getValue(), true, healthMap, true, true)).reduce(true, (a, b) -> a != false && b != false);
        }
        if (result) {
            logger.info("SOFABoot HealthChecker readiness check result: success.");
        } else {
            logger.error(ErrorCode.convert((String)"01-23000"));
        }
        return result;
    }

    private boolean doHealthCheck(String beanId, HealthChecker healthChecker, boolean isRetry, Map<String, Health> healthMap, boolean isReadiness, boolean wait) {
        boolean result;
        Health health;
        Assert.notNull(healthMap, (String)"HealthMap must not be null");
        String checkType = isReadiness ? "readiness" : "liveness";
        logger.info("HealthChecker [{}] {} check start.", (Object)beanId, (Object)checkType);
        healthChecker = this.wrapperHealthCheckerForCustomProperty(healthChecker);
        BaseStat baseStat = new BaseStat();
        baseStat.setName(healthChecker.getComponentName());
        baseStat.putAttribute("type", "HealthChecker");
        baseStat.setStartTime(System.currentTimeMillis());
        int retryCount = 0;
        int timeout = healthChecker.getTimeout();
        do {
            try {
                if (wait) {
                    Future<Health> future = this.healthCheckExecutor.submit(new AsyncHealthCheckCallable(healthChecker));
                    health = future.get(timeout, TimeUnit.MILLISECONDS);
                } else {
                    health = healthChecker.isHealthy();
                }
            }
            catch (TimeoutException e) {
                logger.error("Timeout occurred while doing HealthChecker[{}] {} check, the timeout value is: {}ms.", new Object[]{beanId, checkType, timeout});
                health = new Health.Builder().withException((Throwable)e).withDetail("timeout", (Object)timeout).status(Status.UNKNOWN).build();
            }
            catch (Throwable e) {
                logger.error(String.format("Exception occurred while wait the result of HealthChecker[%s] %s check.", beanId, checkType), e);
                health = new Health.Builder().withException(e).status(Status.DOWN).build();
            }
            result = health.getStatus().equals((Object)Status.UP);
            if (result) break;
            logger.info("HealthChecker[{}] {} check fail with {} retry.", new Object[]{beanId, checkType, retryCount});
            if (!isRetry || retryCount >= healthChecker.getRetryCount()) continue;
            try {
                ++retryCount;
                TimeUnit.MILLISECONDS.sleep(healthChecker.getRetryTimeInterval());
            }
            catch (InterruptedException e) {
                logger.error(ErrorCode.convert((String)"01-23002", (Object[])new Object[]{retryCount, beanId, checkType}), (Throwable)e);
            }
        } while (isRetry && retryCount < healthChecker.getRetryCount());
        baseStat.setEndTime(System.currentTimeMillis());
        this.healthCheckerStartupStatList.add(baseStat);
        healthMap.put(beanId, health);
        try {
            if (!result) {
                if (healthChecker.isStrictCheck()) {
                    logger.error(ErrorCode.convert((String)"01-23001", (Object[])new Object[]{beanId, checkType, retryCount, this.objectMapper.writeValueAsString((Object)health.getDetails()), healthChecker.isStrictCheck()}));
                } else {
                    logger.warn(ErrorCode.convert((String)"01-23001", (Object[])new Object[]{beanId, checkType, retryCount, this.objectMapper.writeValueAsString((Object)health.getDetails()), healthChecker.isStrictCheck()}));
                }
            }
        }
        catch (JsonProcessingException ex) {
            logger.error(ErrorCode.convert((String)"01-23003", (Object[])new Object[]{checkType}), (Throwable)ex);
        }
        return !healthChecker.isStrictCheck() || result;
    }

    private HealthChecker wrapperHealthCheckerForCustomProperty(HealthChecker healthChecker) {
        String componentName = healthChecker.getComponentName();
        Map<String, HealthCheckerConfig> healthCheckerConfigs = this.getHealthCheckerConfigs();
        int retryCount = Optional.ofNullable(healthCheckerConfigs).map(k -> (HealthCheckerConfig)healthCheckerConfigs.get(componentName)).map(HealthCheckerConfig::getRetryCount).orElse(healthChecker.getRetryCount());
        Assert.isTrue((retryCount >= 0 ? 1 : 0) != 0, (String)"HealthIndicator retryCount must no less than zero");
        long retryInterval = Optional.ofNullable(healthCheckerConfigs).map(k -> (HealthCheckerConfig)healthCheckerConfigs.get(componentName)).map(HealthCheckerConfig::getRetryTimeInterval).orElse(healthChecker.getRetryTimeInterval());
        Assert.isTrue((retryInterval >= 0L ? 1 : 0) != 0, (String)"HealthIndicator retryInterval must lager than zero");
        boolean strictCheck = Optional.ofNullable(healthCheckerConfigs).map(k -> (HealthCheckerConfig)healthCheckerConfigs.get(componentName)).map(HealthCheckerConfig::getStrictCheck).orElse(healthChecker.isStrictCheck());
        int timeout = Optional.ofNullable(healthCheckerConfigs).map(k -> (HealthCheckerConfig)healthCheckerConfigs.get(componentName)).map(HealthCheckerConfig::getTimeout).orElse(this.globalTimeout);
        Assert.isTrue((timeout > 0 ? 1 : 0) != 0, (String)"HealthIndicator timeout must lager than zero");
        return new WrapperHealthChecker(healthChecker, retryCount, retryInterval, strictCheck, timeout);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ExecutorService getHealthCheckExecutor() {
        return this.healthCheckExecutor;
    }

    public void setHealthCheckExecutor(ExecutorService healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    public int getGlobalTimeout() {
        return this.globalTimeout;
    }

    public void setGlobalTimeout(int globalTimeout) {
        this.globalTimeout = globalTimeout;
    }

    public Map<String, HealthCheckerConfig> getHealthCheckerConfigs() {
        return this.healthCheckerConfigs;
    }

    public void setHealthCheckerConfigs(Map<String, HealthCheckerConfig> healthCheckerConfigs) {
        this.healthCheckerConfigs = healthCheckerConfigs;
    }

    public boolean isParallelCheck() {
        return this.parallelCheck;
    }

    public void setParallelCheck(boolean parallelCheck) {
        this.parallelCheck = parallelCheck;
    }

    public long getParallelCheckTimeout() {
        return this.parallelCheckTimeout;
    }

    public void setParallelCheckTimeout(long parallelCheckTimeout) {
        this.parallelCheckTimeout = parallelCheckTimeout;
    }

    public List<BaseStat> getHealthCheckerStartupStatList() {
        return this.healthCheckerStartupStatList;
    }

    private class AsyncHealthCheckCallable
    implements Callable<Health> {
        private final HealthChecker healthChecker;

        public AsyncHealthCheckCallable(HealthChecker healthChecker) {
            this.healthChecker = healthChecker;
        }

        @Override
        public Health call() throws Exception {
            return this.healthChecker.isHealthy();
        }
    }

    public static class WrapperHealthChecker
    implements HealthChecker {
        private final HealthChecker healthCheckChecker;
        private final int retryCount;
        private final long retryTimeInterval;
        private final boolean strictCheck;
        private final int timeout;

        public WrapperHealthChecker(HealthChecker healthChecker, int retryCount, long retryTimeInterval, boolean strictCheck, int timeout) {
            this.healthCheckChecker = healthChecker;
            this.retryCount = retryCount;
            this.retryTimeInterval = retryTimeInterval;
            this.strictCheck = strictCheck;
            this.timeout = timeout;
        }

        @Override
        public Health isHealthy() {
            return this.healthCheckChecker.isHealthy();
        }

        @Override
        public String getComponentName() {
            return this.healthCheckChecker.getComponentName();
        }

        @Override
        public int getRetryCount() {
            return this.retryCount;
        }

        @Override
        public long getRetryTimeInterval() {
            return this.retryTimeInterval;
        }

        @Override
        public boolean isStrictCheck() {
            return this.strictCheck;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }
    }

    private class AsyncHealthCheckRunnable
    implements Runnable {
        private final String key;
        private final HealthChecker value;
        private final Map<String, Health> healthMap;
        private final AtomicBoolean parallelResult;
        private final CountDownLatch countDownLatch;

        public AsyncHealthCheckRunnable(String key, HealthChecker value, Map<String, Health> healthMap, AtomicBoolean parallelResult, CountDownLatch countDownLatch) {
            this.key = key;
            this.value = value;
            this.healthMap = healthMap;
            this.parallelResult = parallelResult;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                if (!HealthCheckerProcessor.this.doHealthCheck(this.key, this.value, false, this.healthMap, true, false)) {
                    this.parallelResult.set(false);
                }
            }
            catch (Throwable t) {
                this.parallelResult.set(false);
                logger.error(ErrorCode.convert((String)"01-22004"), t);
                this.healthMap.put(this.key, new Health.Builder().withException(t).status(Status.DOWN).build());
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

