/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import com.alipay.sofa.boot.actuator.health.HealthCheckComparatorSupport;
import com.alipay.sofa.boot.actuator.health.HealthCheckerConfig;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.startup.BaseStat;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class HealthIndicatorProcessor
implements ApplicationContextAware {
    private static final Logger logger = SofaBootLoggerFactory.getLogger(HealthIndicatorProcessor.class);
    private static final List<String> DEFAULT_EXCLUDE_INDICATORS = Arrays.asList("com.alipay.sofa.boot.actuator.health.NonReadinessCheck", "org.springframework.boot.actuate.availability.ReadinessStateHealthIndicator", "org.springframework.boot.actuate.availability.LivenessStateHealthIndicator");
    private static final String REACTOR_CLASS = "reactor.core.publisher.Mono";
    private static final boolean REACTOR_CLASS_EXIST = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", null);
    private final List<BaseStat> healthIndicatorStartupStatList = new CopyOnWriteArrayList<BaseStat>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AtomicBoolean isInitiated = new AtomicBoolean(false);
    private LinkedHashMap<String, HealthIndicator> healthIndicators = null;
    private ApplicationContext applicationContext;
    private ExecutorService healthCheckExecutor;
    private Set<Class<?>> excludedIndicators = new HashSet();
    private int globalTimeout;
    private Map<String, HealthCheckerConfig> healthIndicatorConfig;
    private boolean parallelCheck;
    private long parallelCheckTimeout;

    public void init() {
        if (this.isInitiated.compareAndSet(false, true)) {
            Assert.notNull((Object)this.applicationContext, () -> "Application must not be null");
            Assert.notNull((Object)this.healthCheckExecutor, () -> "HealthCheckExecutor must not be null");
            Map beansOfType = this.applicationContext.getBeansOfType(HealthIndicator.class);
            if (REACTOR_CLASS_EXIST) {
                this.applicationContext.getBeansOfType(ReactiveHealthIndicator.class).forEach((name, indicator) -> beansOfType.put(name, () -> (Health)indicator.health().block()));
            }
            this.healthIndicators = beansOfType.entrySet().stream().filter(entry -> !this.isExcluded(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
            this.healthIndicators = HealthCheckComparatorSupport.sortMapAccordingToValue(this.healthIndicators, HealthCheckComparatorSupport.getComparatorToUse((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory()));
            String healthIndicatorInfo = "Found " + this.healthIndicators.size() + " HealthIndicator implementation:" + String.join((CharSequence)",", this.healthIndicators.keySet());
            logger.info(healthIndicatorInfo);
        }
    }

    public void initExcludedIndicators(List<String> excludes) {
        if (CollectionUtils.isEmpty(excludes)) {
            excludes = DEFAULT_EXCLUDE_INDICATORS;
        } else {
            excludes.addAll(DEFAULT_EXCLUDE_INDICATORS);
        }
        this.excludedIndicators = new HashSet();
        for (String exclude : excludes) {
            try {
                Class<?> c = Class.forName(exclude);
                this.excludedIndicators.add(c);
            }
            catch (Throwable e) {
                logger.warn("Unable to find excluded HealthIndicator class {}, just ignore it.", (Object)exclude);
            }
        }
    }

    public boolean isExcluded(Object target) {
        Class klass = AopProxyUtils.ultimateTargetClass((Object)target);
        for (Class<?> c : this.excludedIndicators) {
            if (!c.isAssignableFrom(klass)) continue;
            return true;
        }
        return false;
    }

    public boolean readinessHealthCheck(Map<String, Health> healthMap) {
        boolean result;
        Assert.notNull(this.healthIndicators, () -> "HealthIndicators must not be null.");
        logger.info("Begin SOFABoot HealthIndicator readiness check.");
        String checkComponentNames = String.join((CharSequence)",", this.healthIndicators.keySet());
        logger.info("SOFABoot HealthIndicator readiness check {} item: {}.", (Object)this.healthIndicators.size(), (Object)checkComponentNames);
        if (this.isParallelCheck()) {
            CountDownLatch countDownLatch = new CountDownLatch(this.healthIndicators.size());
            AtomicBoolean parallelResult = new AtomicBoolean(true);
            this.healthIndicators.forEach((key, value) -> this.healthCheckExecutor.execute(new AsyncHealthIndicatorRunnable((String)key, (HealthIndicator)value, healthMap, parallelResult, countDownLatch)));
            boolean finished = false;
            try {
                finished = countDownLatch.await(this.getParallelCheckTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error(ErrorCode.convert((String)"01-21004"), (Throwable)e);
            }
            if (!finished) {
                parallelResult.set(false);
                healthMap.put("parallelCheck", new Health.Builder().withDetail("timeout", (Object)this.getParallelCheckTimeout()).status(Status.UNKNOWN).build());
            }
            result = finished && parallelResult.get();
        } else {
            result = this.healthIndicators.entrySet().stream().map(entry -> this.doHealthCheck((String)entry.getKey(), (HealthIndicator)entry.getValue(), healthMap, true)).reduce(true, (a, b) -> a != false && b != false);
        }
        if (result) {
            logger.info("SOFABoot HealthIndicator readiness check result: success.");
        } else {
            logger.error(ErrorCode.convert((String)"01-21000"));
        }
        return result;
    }

    public boolean doHealthCheck(String beanId, HealthIndicator healthIndicator, Map<String, Health> healthMap, boolean wait) {
        boolean result;
        Health health;
        Assert.notNull(healthMap, () -> "HealthMap must not be null");
        logger.info("HealthIndicator [{}] readiness check start.", (Object)beanId);
        int timeout = Optional.ofNullable(this.getHealthIndicatorConfig()).map(k -> this.getHealthIndicatorConfig().get(beanId)).map(HealthCheckerConfig::getTimeout).orElse(this.getGlobalTimeout());
        Assert.isTrue((timeout > 0 ? 1 : 0) != 0, (String)"HealthIndicator timeout must lager than zero");
        BaseStat baseStat = new BaseStat();
        baseStat.setName(beanId);
        baseStat.putAttribute("type", "healthIndicator");
        baseStat.setStartTime(System.currentTimeMillis());
        try {
            if (wait) {
                Future<Health> future = this.healthCheckExecutor.submit(new AsyncHealthIndicatorCallable(healthIndicator));
                health = future.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                health = healthIndicator.health();
            }
            Status status = health.getStatus();
            result = status.equals((Object)Status.UP);
            if (!result) {
                logger.error(ErrorCode.convert((String)"01-21001", (Object[])new Object[]{beanId, status, this.objectMapper.writeValueAsString((Object)health.getDetails())}));
            }
        }
        catch (TimeoutException e) {
            result = false;
            logger.error("HealthIndicator[{}] readiness check fail; the status is: {}; the detail is: timeout, the timeout value is: {}ms.", new Object[]{beanId, Status.UNKNOWN, timeout});
            health = new Health.Builder().withException((Throwable)e).withDetail("timeout", (Object)timeout).status(Status.UNKNOWN).build();
        }
        catch (Exception e) {
            result = false;
            logger.error(ErrorCode.convert((String)"01-21002", (Object[])new Object[]{healthIndicator.getClass()}), (Throwable)e);
            health = new Health.Builder().withException((Throwable)e).status(Status.DOWN).build();
        }
        baseStat.setEndTime(System.currentTimeMillis());
        this.healthIndicatorStartupStatList.add(baseStat);
        healthMap.put(this.getKey(beanId), health);
        return result;
    }

    public String getKey(String name) {
        int index = name.toLowerCase().indexOf("healthindicator");
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setHealthCheckExecutor(ExecutorService healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    public int getGlobalTimeout() {
        return this.globalTimeout;
    }

    public void setGlobalTimeout(int globalTimeout) {
        this.globalTimeout = globalTimeout;
    }

    public boolean isParallelCheck() {
        return this.parallelCheck;
    }

    public void setParallelCheck(boolean parallelCheck) {
        this.parallelCheck = parallelCheck;
    }

    public long getParallelCheckTimeout() {
        return this.parallelCheckTimeout;
    }

    public void setParallelCheckTimeout(long parallelCheckTimeout) {
        this.parallelCheckTimeout = parallelCheckTimeout;
    }

    public Map<String, HealthCheckerConfig> getHealthIndicatorConfig() {
        return this.healthIndicatorConfig;
    }

    public void setHealthIndicatorConfig(Map<String, HealthCheckerConfig> healthIndicatorConfig) {
        this.healthIndicatorConfig = healthIndicatorConfig;
    }

    public List<BaseStat> getHealthIndicatorStartupStatList() {
        return this.healthIndicatorStartupStatList;
    }

    private class AsyncHealthIndicatorCallable
    implements Callable<Health> {
        private final HealthIndicator healthIndicator;

        public AsyncHealthIndicatorCallable(HealthIndicator healthIndicator) {
            this.healthIndicator = healthIndicator;
        }

        @Override
        public Health call() throws Exception {
            return this.healthIndicator.health();
        }
    }

    private class AsyncHealthIndicatorRunnable
    implements Runnable {
        private final String key;
        private final HealthIndicator value;
        private final Map<String, Health> healthMap;
        private final AtomicBoolean parallelResult;
        private final CountDownLatch countDownLatch;

        public AsyncHealthIndicatorRunnable(String key, HealthIndicator value, Map<String, Health> healthMap, AtomicBoolean parallelResult, CountDownLatch countDownLatch) {
            this.key = key;
            this.value = value;
            this.healthMap = healthMap;
            this.parallelResult = parallelResult;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                if (!HealthIndicatorProcessor.this.doHealthCheck(this.key, this.value, this.healthMap, false)) {
                    this.parallelResult.set(false);
                }
            }
            catch (Throwable t) {
                this.parallelResult.set(false);
                logger.error(ErrorCode.convert((String)"01-21003"), t);
                this.healthMap.put(this.key, new Health.Builder().withException(t).status(Status.DOWN).build());
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

