/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import com.alipay.sofa.boot.actuator.health.HealthChecker;
import com.alipay.sofa.boot.isle.ApplicationRuntimeModel;
import com.alipay.sofa.boot.isle.deployment.DeploymentDescriptor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class ModuleHealthChecker
implements HealthChecker {
    public static final String COMPONENT_NAME = "modules";
    private final ApplicationRuntimeModel applicationRuntimeModel;

    public ModuleHealthChecker(ApplicationRuntimeModel applicationRuntimeModel) {
        this.applicationRuntimeModel = applicationRuntimeModel;
    }

    @Override
    public Health isHealthy() {
        Health.Builder builder = new Health.Builder();
        for (DeploymentDescriptor deploymentDescriptor : this.applicationRuntimeModel.getFailed()) {
            builder.withDetail(deploymentDescriptor.getName(), (Object)"failed");
        }
        if (this.applicationRuntimeModel.getFailed().size() == 0) {
            return builder.status(Status.UP).build();
        }
        return builder.status(Status.DOWN).build();
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public int getRetryCount() {
        return 0;
    }

    @Override
    public long getRetryTimeInterval() {
        return 1000L;
    }

    @Override
    public boolean isStrictCheck() {
        return true;
    }

    @Override
    public int getTimeout() {
        return 10000;
    }
}

