/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.isle;

import com.alipay.sofa.boot.isle.ApplicationRuntimeModel;
import com.alipay.sofa.boot.isle.deployment.DeploymentDescriptor;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;

@Endpoint(id="isle")
public class IsleEndpoint {
    private final ApplicationRuntimeModel applicationRuntimeModel;

    public IsleEndpoint(ApplicationRuntimeModel applicationRuntimeModel) {
        this.applicationRuntimeModel = applicationRuntimeModel;
    }

    @ReadOperation
    public IsleDescriptor modules() {
        List<ModuleDisplayInfo> installedModuleList = this.convertModuleDisplayInfoList(this.applicationRuntimeModel.getInstalled());
        List<ModuleDisplayInfo> failedModuleList = this.convertModuleDisplayInfoList(this.applicationRuntimeModel.getFailed());
        List<ModuleDisplayInfo> inactiveModuleList = this.convertModuleDisplayInfoList(this.applicationRuntimeModel.getAllInactiveDeployments());
        return new IsleDescriptor(installedModuleList, failedModuleList, inactiveModuleList);
    }

    private List<ModuleDisplayInfo> convertModuleDisplayInfoList(List<DeploymentDescriptor> deploymentDescriptors) {
        return deploymentDescriptors.stream().map(this::createBaseModuleInfo).collect(Collectors.toList());
    }

    private ModuleDisplayInfo createBaseModuleInfo(DeploymentDescriptor dd) {
        ModuleDisplayInfo moduleDisplayInfo = new ModuleDisplayInfo();
        moduleDisplayInfo.setName(dd.getModuleName());
        moduleDisplayInfo.setResourceName(dd.getName());
        moduleDisplayInfo.setSpringParent(dd.getSpringParent());
        moduleDisplayInfo.setRequireModules(dd.getRequiredModules());
        ApplicationContext applicationContext = dd.getApplicationContext();
        if (applicationContext != null) {
            moduleDisplayInfo.setInstallSpringXmls(dd.getInstalledSpringXml());
            moduleDisplayInfo.setElapsedTime(dd.getElapsedTime());
            moduleDisplayInfo.setStartupTime(dd.getStartTime());
        }
        return moduleDisplayInfo;
    }

    public static final class IsleDescriptor
    implements OperationResponseBody {
        private final List<ModuleDisplayInfo> installedModuleList;
        private final List<ModuleDisplayInfo> failedModuleList;
        private final List<ModuleDisplayInfo> inactiveModuleList;

        public IsleDescriptor(List<ModuleDisplayInfo> installedModuleList, List<ModuleDisplayInfo> failedModuleList, List<ModuleDisplayInfo> inactiveModuleList) {
            this.installedModuleList = installedModuleList;
            this.failedModuleList = failedModuleList;
            this.inactiveModuleList = inactiveModuleList;
        }

        public List<ModuleDisplayInfo> getInstalledModuleList() {
            return this.installedModuleList;
        }

        public List<ModuleDisplayInfo> getFailedModuleList() {
            return this.failedModuleList;
        }

        public List<ModuleDisplayInfo> getInactiveModuleList() {
            return this.inactiveModuleList;
        }
    }

    public static final class ModuleDisplayInfo {
        private String name;
        private String springParent;
        private List<String> requireModules;
        private String resourceName;
        private long startupTime;
        private long elapsedTime;
        private List<String> installSpringXmls;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSpringParent() {
            return this.springParent;
        }

        public void setSpringParent(String springParent) {
            this.springParent = springParent;
        }

        public List<String> getRequireModules() {
            return this.requireModules;
        }

        public void setRequireModules(List<String> requireModules) {
            this.requireModules = requireModules;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public List<String> getInstallSpringXmls() {
            return this.installSpringXmls;
        }

        public void setInstallSpringXmls(List<String> installSpringXmls) {
            this.installSpringXmls = installSpringXmls;
        }

        public long getStartupTime() {
            return this.startupTime;
        }

        public void setStartupTime(long startupTime) {
            this.startupTime = startupTime;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }
    }
}

