/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.ark;

import com.alipay.sofa.boot.ark.SofaRuntimeContainer;
import com.alipay.sofa.boot.ark.invoke.ArkDynamicServiceProxyManager;
import com.alipay.sofa.boot.autoconfigure.ark.SofaArkProperties;
import com.alipay.sofa.boot.autoconfigure.runtime.SofaRuntimeAutoConfiguration;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.service.DynamicServiceProxyManager;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={SofaRuntimeAutoConfiguration.class})
@ConditionalOnBean(value={SofaRuntimeManager.class})
@ConditionalOnClass(value={SofaRuntimeContainer.class, SofaRuntimeManager.class})
@EnableConfigurationProperties(value={SofaArkProperties.class})
public class SofaArkAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SofaRuntimeContainer sofaRuntimeContainer(SofaRuntimeManager sofaRuntimeManager, SofaArkProperties sofaArkProperties) {
        SofaRuntimeContainer sofaRuntimeContainer = new SofaRuntimeContainer(sofaRuntimeManager);
        sofaRuntimeContainer.setJvmServiceCache(sofaArkProperties.isJvmServiceCache());
        sofaRuntimeContainer.setJvmInvokeSerialize(sofaArkProperties.isJvmInvokeSerialize());
        return sofaRuntimeContainer;
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicServiceProxyManager arkDynamicServiceProxyManager() {
        return new ArkDynamicServiceProxyManager();
    }
}

