/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.condition;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.boot.autoconfigure.condition.ConditionalOnMasterBiz;
import com.alipay.sofa.boot.util.SofaBootEnvUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class OnMasterBizCondition
extends SpringBootCondition {
    private static Object masterBiz;

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ClassLoader contextClassLoader;
        if (!SofaBootEnvUtils.isArkEnv()) {
            return new ConditionOutcome(true, "SOFAArk has not started.");
        }
        if (masterBiz == null) {
            String masterBizName = ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz");
            List biz = ArkClient.getBizManagerService().getBiz(masterBizName);
            Assert.isTrue((biz.size() == 1 ? 1 : 0) != 0, (String)"master biz should have and only have one.");
            masterBiz = biz.get(0);
        }
        if ((contextClassLoader = Thread.currentThread().getContextClassLoader()).equals(((Biz)masterBiz).getBizClassLoader())) {
            return new ConditionOutcome(true, "Current context classloader equals master biz classloader.");
        }
        List<AnnotationAttributes> allAnnotationAttributes = this.annotationAttributesFromMultiValueMap((MultiValueMap<String, Object>)metadata.getAllAnnotationAttributes(ConditionalOnMasterBiz.class.getName()));
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            Spec spec = new Spec(annotationAttributes);
            String extensionCondition = spec.getExtensionCondition();
            String property = context.getEnvironment().getProperty(extensionCondition);
            if (!"true".equalsIgnoreCase(property)) continue;
            return new ConditionOutcome(true, "Current context classloader not equals master biz classloader, but allow by extension condition.");
        }
        return new ConditionOutcome(false, "Current context classloader not equals master biz classloader.");
    }

    private List<AnnotationAttributes> annotationAttributesFromMultiValueMap(MultiValueMap<String, Object> multiValueMap) {
        ArrayList maps = new ArrayList();
        multiValueMap.forEach((key, value) -> {
            for (int i = 0; i < value.size(); ++i) {
                Map map;
                if (i < maps.size()) {
                    map = (Map)maps.get(i);
                } else {
                    map = new HashMap();
                    maps.add(map);
                }
                map.put((String)key, value.get(i));
            }
        });
        ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>(maps.size());
        for (Map map : maps) {
            annotationAttributes.add(AnnotationAttributes.fromMap((Map)map));
        }
        return annotationAttributes;
    }

    private static class Spec {
        private final String extensionCondition;

        Spec(AnnotationAttributes annotationAttributes) {
            this.extensionCondition = annotationAttributes.getString("extensionCondition");
        }

        public String getExtensionCondition() {
            return this.extensionCondition;
        }
    }
}

