/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.condition;

import com.alipay.sofa.boot.autoconfigure.condition.ConditionalOnSwitch;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.StringUtils;

public class OnSwitchCondition
extends SpringBootCondition {
    private static final String CONFIG_KEY_PREFIX = "sofa.boot.switch.bean";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return this.getMatchOutcome(context.getEnvironment(), metadata);
    }

    private ConditionOutcome getMatchOutcome(Environment environment, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnSwitch.class, (Object[])new Object[0]);
        String key = this.getKey(metadata);
        Boolean userDefinedEnabled = (Boolean)environment.getProperty(key, Boolean.class);
        if (userDefinedEnabled != null) {
            return new ConditionOutcome(userDefinedEnabled.booleanValue(), message.because("found property " + key + " with value " + userDefinedEnabled));
        }
        MergedAnnotation conditionAnnotation = metadata.getAnnotations().get(ConditionalOnSwitch.class);
        Boolean matchIfMissing = conditionAnnotation.getBoolean("matchIfMissing");
        return new ConditionOutcome(matchIfMissing.booleanValue(), message.because("matchIfMissing " + key + " with value " + matchIfMissing));
    }

    private String getKey(AnnotatedTypeMetadata metadata) {
        MergedAnnotation conditionAnnotation = metadata.getAnnotations().get(ConditionalOnSwitch.class);
        String key = conditionAnnotation.getString("value");
        if (StringUtils.hasText((String)key)) {
            return CONFIG_KEY_PREFIX.concat(".").concat(key).concat(".enabled");
        }
        return CONFIG_KEY_PREFIX.concat(".").concat(this.getClassOrMethodName(metadata)).concat(".enabled");
    }

    private String getClassOrMethodName(AnnotatedTypeMetadata metadata) {
        if (metadata instanceof ClassMetadata) {
            ClassMetadata classMetadata = (ClassMetadata)metadata;
            return classMetadata.getClassName();
        }
        MethodMetadata methodMetadata = (MethodMetadata)metadata;
        return methodMetadata.getMethodName();
    }
}

