/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.rpc;

import com.alipay.sofa.boot.autoconfigure.condition.ConditionalOnSwitch;
import com.alipay.sofa.rpc.config.JAXRSProviderManager;
import java.util.List;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSwitch(value="rpcRestFilter")
public class RestFilterConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ContainerRequestFilterContainer containerRequestFilters(List<ContainerRequestFilter> containerRequestFilters) {
        for (ContainerRequestFilter filter : containerRequestFilters) {
            JAXRSProviderManager.registerCustomProviderInstance((Object)filter);
        }
        return new ContainerRequestFilterContainer(containerRequestFilters);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContainerResponseFilterContainer containerResponseFilters(List<ContainerResponseFilter> containerResponseFilters) {
        for (ContainerResponseFilter filter : containerResponseFilters) {
            JAXRSProviderManager.registerCustomProviderInstance((Object)filter);
        }
        return new ContainerResponseFilterContainer(containerResponseFilters);
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientRequestFilterContainer clientRequestFilters(List<ClientRequestFilter> clientRequestFilters) {
        for (ClientRequestFilter filter : clientRequestFilters) {
            JAXRSProviderManager.registerCustomProviderInstance((Object)filter);
        }
        return new ClientRequestFilterContainer(clientRequestFilters);
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientResponseFilterContainer clientResponseFilters(List<ClientResponseFilter> clientResponseFilters) {
        for (ClientResponseFilter filter : clientResponseFilters) {
            JAXRSProviderManager.registerCustomProviderInstance((Object)filter);
        }
        return new ClientResponseFilterContainer(clientResponseFilters);
    }

    static class ContainerRequestFilterContainer {
        private List<ContainerRequestFilter> containerRequestFilters;

        public ContainerRequestFilterContainer(List<ContainerRequestFilter> containerRequestFilters) {
            this.containerRequestFilters = containerRequestFilters;
        }
    }

    static class ContainerResponseFilterContainer {
        private List<ContainerResponseFilter> containerResponseFilters;

        public ContainerResponseFilterContainer(List<ContainerResponseFilter> containerResponseFilters) {
            this.containerResponseFilters = containerResponseFilters;
        }
    }

    static class ClientRequestFilterContainer {
        private List<ClientRequestFilter> clientRequestFilters;

        public ClientRequestFilterContainer(List<ClientRequestFilter> clientRequestFilters) {
            this.clientRequestFilters = clientRequestFilters;
        }
    }

    static class ClientResponseFilterContainer {
        private List<ClientResponseFilter> clientResponseFilters;

        public ClientResponseFilterContainer(List<ClientResponseFilter> clientResponseFilters) {
            this.clientResponseFilters = clientResponseFilters;
        }
    }
}

