/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.rpc;

import com.alipay.sofa.boot.autoconfigure.condition.ConditionalOnSwitch;
import com.alipay.sofa.rpc.boot.swagger.BoltSwaggerServiceApplicationListener;
import com.alipay.sofa.rpc.boot.swagger.SwaggerServiceApplicationListener;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import io.swagger.models.Swagger;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSwitch(value="rpcSwagger")
@ConditionalOnBean(value={SofaRuntimeManager.class})
public class SwaggerConfiguration {

    @ConditionalOnClass(value={JaxrsOpenApiContextBuilder.class})
    @ConditionalOnProperty(name={"sofa.boot.rpc.rest-swagger"}, havingValue="true")
    static class SwaggerV2Configuration {
        SwaggerV2Configuration() {
        }

        @Bean
        public ApplicationListener<ApplicationStartedEvent> swaggerServiceApplicationListener(SofaRuntimeManager sofaRuntimeManager) {
            return new SwaggerServiceApplicationListener(sofaRuntimeManager);
        }
    }

    @ConditionalOnClass(value={Swagger.class})
    @ConditionalOnProperty(name={"sofa.boot.rpc.enable-swagger"}, havingValue="true")
    static class SwaggerV1Configuration {
        SwaggerV1Configuration() {
        }

        @Bean
        public ApplicationListener<ApplicationStartedEvent> boltSwaggerServiceApplicationListener(SofaRuntimeManager sofaRuntimeManager) {
            return new BoltSwaggerServiceApplicationListener(sofaRuntimeManager);
        }
    }
}

