/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.datasource;

import com.alipay.sofa.boot.tracer.datasource.DataSourceBeanPostProcessor;
import com.alipay.sofa.tracer.plugins.datasource.SmartDataSource;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={SmartDataSource.class, DataSourceBeanPostProcessor.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.datasource.enabled"}, havingValue="true", matchIfMissing=true)
public class DataSourceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static DataSourceBeanPostProcessor dataSourceBeanPostProcessor(Environment environment) {
        String appName = environment.getProperty("spring.application.name");
        DataSourceBeanPostProcessor dataSourceBeanPostProcessor = new DataSourceBeanPostProcessor();
        dataSourceBeanPostProcessor.setAppName(appName);
        return dataSourceBeanPostProcessor;
    }
}

