/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.kafka;

import com.alipay.sofa.boot.tracer.kafka.KafkaConsumerFactoryBeanPostProcessor;
import com.alipay.sofa.boot.tracer.kafka.KafkaProducerBeanFactoryPostProcessor;
import com.sofa.alipay.tracer.plugins.kafkamq.aspect.KafkaListenerSofaTracerAspect;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.kafka.core.ProducerFactory;

@AutoConfiguration(after={org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
@ConditionalOnClass(value={ProducerFactory.class, KafkaConsumerFactoryBeanPostProcessor.class, KafkaListenerSofaTracerAspect.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.kafka.enabled"}, havingValue="true", matchIfMissing=true)
public class KafkaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static KafkaConsumerFactoryBeanPostProcessor kafkaConsumerFactoryPostProcessor() {
        return new KafkaConsumerFactoryBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public static KafkaProducerBeanFactoryPostProcessor kafkaProducerFactoryPostProcessor() {
        return new KafkaProducerBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaListenerSofaTracerAspect kafkaListenerSofaTracerAspect() {
        return new KafkaListenerSofaTracerAspect();
    }
}

