/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.springmessage;

import com.alipay.sofa.boot.tracer.springmessage.SpringMessageTracerBeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

@AutoConfiguration
@ConditionalOnClass(value={AbstractMessageChannel.class, ChannelInterceptor.class, DirectWithAttributesChannel.class, SpringMessageTracerBeanPostProcessor.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.springmessage.enabled"}, havingValue="true", matchIfMissing=true)
public class SpringMessageAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static SpringMessageTracerBeanPostProcessor springMessageTracerBeanPostProcessor(Environment environment) {
        String appName = environment.getProperty("spring.application.name");
        SpringMessageTracerBeanPostProcessor springMessageTracerBeanPostProcessor = new SpringMessageTracerBeanPostProcessor();
        springMessageTracerBeanPostProcessor.setAppName(appName);
        return springMessageTracerBeanPostProcessor;
    }
}

