/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.rpc;

import com.alipay.sofa.boot.autoconfigure.condition.ConditionalOnSwitch;
import com.alipay.sofa.boot.autoconfigure.rpc.RegistryConfigurations;
import com.alipay.sofa.boot.autoconfigure.rpc.RestFilterConfiguration;
import com.alipay.sofa.boot.autoconfigure.rpc.SofaBootRpcProperties;
import com.alipay.sofa.boot.autoconfigure.rpc.SwaggerConfiguration;
import com.alipay.sofa.boot.autoconfigure.runtime.SofaRuntimeAutoConfiguration;
import com.alipay.sofa.rpc.boot.config.FaultToleranceConfigurator;
import com.alipay.sofa.rpc.boot.config.RegistryConfigureProcessor;
import com.alipay.sofa.rpc.boot.container.ConsumerConfigContainer;
import com.alipay.sofa.rpc.boot.container.ProviderConfigContainer;
import com.alipay.sofa.rpc.boot.container.ProviderConfigDelayRegisterChecker;
import com.alipay.sofa.rpc.boot.container.RegistryConfigContainer;
import com.alipay.sofa.rpc.boot.container.ServerConfigContainer;
import com.alipay.sofa.rpc.boot.context.RpcStartApplicationListener;
import com.alipay.sofa.rpc.boot.context.RpcStopApplicationListener;
import com.alipay.sofa.rpc.boot.context.SofaBootRpcStartListener;
import com.alipay.sofa.rpc.boot.runtime.adapter.helper.ConsumerConfigHelper;
import com.alipay.sofa.rpc.boot.runtime.adapter.helper.ProviderConfigHelper;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ConsumerConfigProcessor;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ConsumerMockProcessor;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.DynamicConfigProcessor;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ProcessorContainer;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ProviderConfigProcessor;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ProviderRegisterProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@AutoConfiguration(after={SofaRuntimeAutoConfiguration.class})
@ConditionalOnClass(value={ProviderConfigContainer.class})
@EnableConfigurationProperties(value={SofaBootRpcProperties.class})
@Import(value={RegistryConfigurationImportSelector.class, SwaggerConfiguration.class, RestFilterConfiguration.class})
public class SofaRpcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ProviderConfigContainer providerConfigContainer(SofaBootRpcProperties sofaBootRpcProperties, ObjectProvider<ProviderConfigDelayRegisterChecker> providerConfigDelayRegisterCheckers) {
        ProviderConfigContainer providerConfigContainer = new ProviderConfigContainer();
        providerConfigContainer.setProviderRegisterWhiteList(sofaBootRpcProperties.getProviderRegisterWhiteList());
        providerConfigContainer.setProviderRegisterBlackList(sofaBootRpcProperties.getProviderRegisterBlackList());
        providerConfigContainer.setProviderConfigDelayRegister(providerConfigDelayRegisterCheckers.stream().collect(Collectors.toList()));
        providerConfigContainer.setEnableDelayRegister(sofaBootRpcProperties.isEnableDelayRegister());
        return providerConfigContainer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnSwitch(value="rpcFaultToleranceConfigurator")
    public FaultToleranceConfigurator faultToleranceConfigurator(SofaBootRpcProperties sofaBootRpcProperties, Environment environment) {
        FaultToleranceConfigurator faultToleranceConfigurator = new FaultToleranceConfigurator();
        faultToleranceConfigurator.setAppName(environment.getProperty("spring.application.name"));
        faultToleranceConfigurator.setRegulationEffectiveStr(sofaBootRpcProperties.getAftRegulationEffective());
        faultToleranceConfigurator.setDegradeEffectiveStr(sofaBootRpcProperties.getAftDegradeEffective());
        faultToleranceConfigurator.setTimeWindowStr(sofaBootRpcProperties.getAftTimeWindow());
        faultToleranceConfigurator.setLeastWindowCountStr(sofaBootRpcProperties.getAftLeastWindowCount());
        faultToleranceConfigurator.setLeastWindowExceptionRateMultipleStr(sofaBootRpcProperties.getAftLeastWindowExceptionRateMultiple());
        faultToleranceConfigurator.setWeightDegradeRateStr(sofaBootRpcProperties.getAftWeightDegradeRate());
        faultToleranceConfigurator.setWeightRecoverRateStr(sofaBootRpcProperties.getAftWeightRecoverRate());
        faultToleranceConfigurator.setDegradeLeastWeightStr(sofaBootRpcProperties.getAftDegradeLeastWeight());
        faultToleranceConfigurator.setDegradeMaxIpCountStr(sofaBootRpcProperties.getAftDegradeMaxIpCount());
        return faultToleranceConfigurator;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerConfigContainer serverConfigContainer(SofaBootRpcProperties sofaBootRpcProperties) {
        ServerConfigContainer serverConfigContainer = new ServerConfigContainer();
        serverConfigContainer.setEnabledIpRange(sofaBootRpcProperties.getEnabledIpRange());
        serverConfigContainer.setBindNetworkInterface(sofaBootRpcProperties.getBindNetworkInterface());
        serverConfigContainer.setBoundHostStr(sofaBootRpcProperties.getBoundHost());
        serverConfigContainer.setVirtualHostStr(sofaBootRpcProperties.getVirtualHost());
        serverConfigContainer.setVirtualPortStr(sofaBootRpcProperties.getVirtualPort());
        serverConfigContainer.setH2cPortStr(sofaBootRpcProperties.getH2cPort());
        serverConfigContainer.setH2cThreadPoolCoreSizeStr(sofaBootRpcProperties.getH2cThreadPoolCoreSize());
        serverConfigContainer.setH2cThreadPoolMaxSizeStr(sofaBootRpcProperties.getH2cThreadPoolMaxSize());
        serverConfigContainer.setH2cAcceptsSizeStr(sofaBootRpcProperties.getH2cAcceptsSize());
        serverConfigContainer.setH2cThreadPoolQueueSizeStr(sofaBootRpcProperties.getH2cThreadPoolQueueSize());
        serverConfigContainer.setBoltPortStr(sofaBootRpcProperties.getBoltPort());
        serverConfigContainer.setBoltThreadPoolCoreSizeStr(sofaBootRpcProperties.getBoltThreadPoolCoreSize());
        serverConfigContainer.setBoltThreadPoolMaxSizeStr(sofaBootRpcProperties.getBoltThreadPoolMaxSize());
        serverConfigContainer.setBoltAcceptsSizeStr(sofaBootRpcProperties.getBoltAcceptsSize());
        serverConfigContainer.setBoltThreadPoolQueueSizeStr(sofaBootRpcProperties.getBoltThreadPoolQueueSize());
        serverConfigContainer.setBoltProcessInIoThread(sofaBootRpcProperties.getBoltProcessInIoThread());
        serverConfigContainer.setRestHostName(sofaBootRpcProperties.getRestHostname());
        serverConfigContainer.setRestPortStr(sofaBootRpcProperties.getRestPort());
        serverConfigContainer.setRestIoThreadSizeStr(sofaBootRpcProperties.getRestIoThreadSize());
        serverConfigContainer.setRestContextPath(sofaBootRpcProperties.getRestContextPath());
        serverConfigContainer.setRestThreadPoolMaxSizeStr(sofaBootRpcProperties.getRestThreadPoolMaxSize());
        serverConfigContainer.setRestMaxRequestSizeStr(sofaBootRpcProperties.getRestMaxRequestSize());
        serverConfigContainer.setRestTelnetStr(sofaBootRpcProperties.getRestTelnet());
        serverConfigContainer.setRestDaemonStr(sofaBootRpcProperties.getRestDaemon());
        serverConfigContainer.setRestAllowedOrigins(sofaBootRpcProperties.getRestAllowedOrigins());
        serverConfigContainer.setDubboPortStr(sofaBootRpcProperties.getDubboPort());
        serverConfigContainer.setDubboIoThreadSizeStr(sofaBootRpcProperties.getDubboIoThreadSize());
        serverConfigContainer.setDubboThreadPoolMaxSizeStr(sofaBootRpcProperties.getDubboThreadPoolMaxSize());
        serverConfigContainer.setDubboAcceptsSizeStr(sofaBootRpcProperties.getDubboAcceptsSize());
        serverConfigContainer.setHttpPortStr(sofaBootRpcProperties.getHttpPort());
        serverConfigContainer.setHttpThreadPoolCoreSizeStr(sofaBootRpcProperties.getHttpThreadPoolCoreSize());
        serverConfigContainer.setHttpThreadPoolMaxSizeStr(sofaBootRpcProperties.getHttpThreadPoolMaxSize());
        serverConfigContainer.setHttpAcceptsSizeStr(sofaBootRpcProperties.getHttpAcceptsSize());
        serverConfigContainer.setHttpThreadPoolQueueSizeStr(sofaBootRpcProperties.getHttpThreadPoolQueueSize());
        serverConfigContainer.setTriplePortStr(sofaBootRpcProperties.getTriplePort());
        serverConfigContainer.setTripleThreadPoolCoreSizeStr(sofaBootRpcProperties.getTripleThreadPoolCoreSize());
        serverConfigContainer.setTripleThreadPoolMaxSizeStr(sofaBootRpcProperties.getTripleThreadPoolMaxSize());
        serverConfigContainer.setTripleAcceptsSizeStr(sofaBootRpcProperties.getTripleAcceptsSize());
        serverConfigContainer.setTripleThreadPoolQueueSizeStr(sofaBootRpcProperties.getTripleThreadPoolQueueSize());
        return serverConfigContainer;
    }

    @Bean
    @ConditionalOnMissingBean
    public RegistryConfigContainer registryConfigContainer(SofaBootRpcProperties sofaBootRpcProperties, Environment environment, @Qualifier(value="registryConfigMap") Map<String, RegistryConfigureProcessor> registryConfigMap) {
        RegistryConfigContainer registryConfigContainer = new RegistryConfigContainer(registryConfigMap);
        registryConfigContainer.setDefaultRegistryAddress(sofaBootRpcProperties.getRegistryAddress());
        registryConfigContainer.setRegistries(sofaBootRpcProperties.getRegistries());
        registryConfigContainer.setMeshConfig(sofaBootRpcProperties.getEnableMesh());
        registryConfigContainer.setIgnoreRegistry(Boolean.parseBoolean(environment.getProperty("rpc_register_registry_ignore")));
        return registryConfigContainer;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsumerConfigHelper consumerConfigHelper(SofaBootRpcProperties sofaBootRpcProperties, RegistryConfigContainer registryConfigContainer, Environment environment) {
        String appName = environment.getProperty("spring.application.name");
        ConsumerConfigHelper configHelper = new ConsumerConfigHelper(registryConfigContainer, appName);
        configHelper.setReferenceLimit(sofaBootRpcProperties.getConsumerRepeatedReferenceLimit());
        configHelper.setHystrixEnable(sofaBootRpcProperties.getHystrixEnable());
        return configHelper;
    }

    @Bean
    @ConditionalOnMissingBean
    public ProviderConfigHelper providerConfigHelper(ServerConfigContainer serverConfigContainer, RegistryConfigContainer registryConfigContainer, Environment environment) {
        String appName = environment.getProperty("spring.application.name");
        return new ProviderConfigHelper(serverConfigContainer, registryConfigContainer, appName);
    }

    @Bean(name={"registryConfigMap"})
    @ConditionalOnMissingBean(name={"registryConfigMap"})
    public Map<String, RegistryConfigureProcessor> configureProcessorMap(List<RegistryConfigureProcessor> processorList) {
        HashMap<String, RegistryConfigureProcessor> map = new HashMap<String, RegistryConfigureProcessor>();
        for (RegistryConfigureProcessor processor : processorList) {
            map.put(processor.registryType(), processor);
        }
        return map;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsumerConfigContainer consumerConfigContainer() {
        return new ConsumerConfigContainer();
    }

    @Bean
    @ConditionalOnMissingBean
    public RpcStopApplicationListener applicationContextClosedListener(ProviderConfigContainer providerConfigContainer, ServerConfigContainer serverConfigContainer) {
        return new RpcStopApplicationListener(providerConfigContainer, serverConfigContainer);
    }

    @Bean
    @ConditionalOnMissingBean
    public RpcStartApplicationListener applicationContextRefreshedListener(SofaBootRpcProperties sofaBootRpcProperties) {
        RpcStartApplicationListener rpcStartApplicationListener = new RpcStartApplicationListener();
        rpcStartApplicationListener.setEnableAutoPublish(sofaBootRpcProperties.isEnableAutoPublish());
        return rpcStartApplicationListener;
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaBootRpcStartListener sofaBootRpcStartListener(SofaBootRpcProperties sofaBootRpcProperties, ProviderConfigContainer providerConfigContainer, ObjectProvider<FaultToleranceConfigurator> faultToleranceConfigurator, ServerConfigContainer serverConfigContainer, RegistryConfigContainer registryConfigContainer) {
        return new SofaBootRpcStartListener(providerConfigContainer, (FaultToleranceConfigurator)faultToleranceConfigurator.getIfUnique(), serverConfigContainer, registryConfigContainer);
    }

    @Bean
    @ConditionalOnMissingBean
    public ProcessorContainer processorContainer(List<ProviderConfigProcessor> providerConfigProcessors, List<ConsumerConfigProcessor> consumerConfigProcessors) {
        return new ProcessorContainer(providerConfigProcessors, consumerConfigProcessors);
    }

    @Bean
    @ConditionalOnProperty(name={"sofa.boot.rpc.mock-url"})
    public ConsumerMockProcessor consumerMockProcessor(Environment environment) {
        return new ConsumerMockProcessor(environment.getProperty("sofa.boot.rpc.mock-url"));
    }

    @Bean
    @ConditionalOnProperty(name={"sofa.boot.rpc.dynamic-config"})
    public DynamicConfigProcessor dynamicConfigProcessor(Environment environment) {
        return new DynamicConfigProcessor(environment.getProperty("sofa.boot.rpc.dynamic-config"));
    }

    @Bean
    @ConditionalOnMissingBean
    public ProviderRegisterProcessor providerRegisterProcessor() {
        return new ProviderRegisterProcessor();
    }

    static class RegistryConfigurationImportSelector
    implements ImportSelector {
        RegistryConfigurationImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return RegistryConfigurations.registryConfigurationClass();
        }
    }
}

