/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.flexible;

import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.samplers.Sampler;
import com.alipay.common.tracer.core.samplers.SamplerFactory;
import com.alipay.sofa.boot.autoconfigure.tracer.SofaTracerProperties;
import com.alipay.sofa.boot.tracer.flexible.MethodInvocationProcessor;
import com.alipay.sofa.boot.tracer.flexible.SofaTracerAdvisingBeanPostProcessor;
import com.alipay.sofa.boot.tracer.flexible.SofaTracerIntroductionInterceptor;
import com.alipay.sofa.boot.tracer.flexible.SofaTracerMethodInvocationProcessor;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleTracer;
import io.opentracing.Tracer;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={Tracer.class, com.alipay.sofa.tracer.plugin.flexible.annotations.Tracer.class, SofaTracerIntroductionInterceptor.class})
@ConditionalOnBean(value={SofaTracerProperties.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.flexible.enabled"}, havingValue="true", matchIfMissing=true)
public class FlexibleAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Tracer sofaTracer(ObjectProvider<SofaTracerProperties> sofaTracerPropertiesObjectProvider) throws Exception {
        SofaTracerProperties sofaTracerProperties = (SofaTracerProperties)sofaTracerPropertiesObjectProvider.getIfUnique();
        String reporterName = null;
        if (sofaTracerProperties != null) {
            reporterName = sofaTracerProperties.getReporterName();
        }
        if (StringUtils.hasText(reporterName)) {
            Reporter reporter = (Reporter)Class.forName(reporterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Sampler sampler = SamplerFactory.getSampler();
            return new FlexibleTracer(sampler, reporter);
        }
        return new FlexibleTracer();
    }

    @Bean
    @ConditionalOnMissingBean
    public MethodInvocationProcessor sofaMethodInvocationProcessor(Tracer tracer) {
        return new SofaTracerMethodInvocationProcessor(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaTracerIntroductionInterceptor sofaTracerIntroductionInterceptor(MethodInvocationProcessor methodInvocationProcessor) {
        return new SofaTracerIntroductionInterceptor(methodInvocationProcessor);
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaTracerAdvisingBeanPostProcessor tracerAnnotationBeanPostProcessor(SofaTracerIntroductionInterceptor methodInterceptor) {
        return new SofaTracerAdvisingBeanPostProcessor((MethodInterceptor)methodInterceptor);
    }
}

