/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.springmvc;

import com.alipay.sofa.boot.autoconfigure.tracer.SofaTracerAutoConfiguration;
import com.alipay.sofa.boot.autoconfigure.tracer.springmvc.OpenTracingSpringMvcProperties;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcSofaTracerFilter;
import com.alipay.sofa.tracer.plugins.webflux.WebfluxSofaTracerFilter;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.WebFilter;

@AutoConfiguration(after={SofaTracerAutoConfiguration.class})
@EnableConfigurationProperties(value={OpenTracingSpringMvcProperties.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.springmvc.enabled"}, havingValue="true", matchIfMissing=true)
public class OpenTracingSpringMvcAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnClass(value={WebFilter.class, WebfluxSofaTracerFilter.class})
    static class WebfluxSofaTracerFilterConfiguration {
        WebfluxSofaTracerFilterConfiguration() {
        }

        @Bean
        @Order(value=-2147483638)
        public WebFilter webfluxSofaTracerFilter() {
            return new WebfluxSofaTracerFilter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={SpringMvcSofaTracerFilter.class})
    static class SpringMvcDelegatingFilterProxyConfiguration {
        SpringMvcDelegatingFilterProxyConfiguration() {
        }

        @Bean
        public FilterRegistrationBean<SpringMvcSofaTracerFilter> springMvcSofaTracerFilter(OpenTracingSpringMvcProperties openTracingSpringMvcProperties) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
            SpringMvcSofaTracerFilter filter = new SpringMvcSofaTracerFilter();
            filterRegistrationBean.setFilter((Filter)filter);
            List<String> urlPatterns = openTracingSpringMvcProperties.getUrlPatterns();
            if (urlPatterns == null || urlPatterns.size() <= 0) {
                filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
            } else {
                filterRegistrationBean.setUrlPatterns(urlPatterns);
            }
            filterRegistrationBean.setName(filter.getFilterName());
            filterRegistrationBean.setAsyncSupported(true);
            filterRegistrationBean.setOrder(openTracingSpringMvcProperties.getFilterOrder());
            return filterRegistrationBean;
        }
    }
}

