/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.zipkin;

import com.alipay.sofa.boot.autoconfigure.tracer.zipkin.ZipkinProperties;
import com.alipay.sofa.tracer.plugins.zipkin.ZipkinSofaTracerRestTemplateCustomizer;
import com.alipay.sofa.tracer.plugins.zipkin.ZipkinSofaTracerSpanRemoteReporter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;

@AutoConfiguration
@EnableConfigurationProperties(value={ZipkinProperties.class})
@ConditionalOnClass(value={Span.class, AsyncReporter.class, RestTemplate.class, ZipkinSofaTracerRestTemplateCustomizer.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.zipkin.enabled"}, havingValue="true", matchIfMissing=true)
public class ZipkinAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZipkinSofaTracerRestTemplateCustomizer zipkinSofaTracerRestTemplateCustomizer(ZipkinProperties zipkinProperties) {
        return new ZipkinSofaTracerRestTemplateCustomizer(zipkinProperties.isGzipped());
    }

    @Bean
    @ConditionalOnMissingBean
    public ZipkinSofaTracerSpanRemoteReporter zipkinSofaTracerSpanReporter(ZipkinSofaTracerRestTemplateCustomizer zipkinSofaTracerRestTemplateCustomizer, ZipkinProperties zipkinProperties) {
        RestTemplate restTemplate = new RestTemplate();
        zipkinSofaTracerRestTemplateCustomizer.customize(restTemplate);
        return new ZipkinSofaTracerSpanRemoteReporter(restTemplate, zipkinProperties.getBaseUrl());
    }
}

