/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.env;

import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Order(value=2147483547)
public class EnvironmentCustomizer
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.getPropertySources().get("sofaConfigurationProperties") != null) {
            return;
        }
        Properties defaultConfiguration = this.getSofaBootVersionProperties();
        defaultConfiguration.put("management.endpoints.web.exposure.include", "info, health, versions, readiness, startup, triggerReadinessCallback");
        defaultConfiguration.put("management.endpoint.health.group.liveness.include", "livenessState,sofaBoot");
        PropertiesPropertySource propertySource = new PropertiesPropertySource("sofaConfigurationProperties", defaultConfiguration);
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setRequiredProperties(new String[]{"spring.application.name"});
    }

    protected Properties getSofaBootVersionProperties() {
        Properties properties = new Properties();
        String sofaBootVersion = this.getSofaBootVersion();
        sofaBootVersion = StringUtils.isEmpty((Object)sofaBootVersion) ? "" : sofaBootVersion;
        String sofaBootFormattedVersion = sofaBootVersion.isEmpty() ? "" : String.format(" (v%s)", sofaBootVersion);
        properties.setProperty("sofa-boot.version", sofaBootVersion);
        properties.setProperty("sofa-boot.formatted-version", sofaBootFormattedVersion);
        return properties;
    }

    protected String getSofaBootVersion() {
        return EnvironmentCustomizer.class.getPackage().getImplementationVersion();
    }
}

