/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.compatibility;

import com.alipay.sofa.boot.compatibility.CompatibilityPredicate;
import com.alipay.sofa.boot.compatibility.CompatibilityVerifier;
import com.alipay.sofa.boot.compatibility.VerificationResult;
import org.springframework.core.env.Environment;

public abstract class AbstractSwitchableCompatibilityVerifier
implements CompatibilityVerifier {
    private static final String ENABLE_KEY_FORMAT = "sofa.boot.compatibility-verifier.%s.enabled";
    protected final Environment environment;
    protected String enableKey;

    public AbstractSwitchableCompatibilityVerifier(Environment environment) {
        this.environment = environment;
    }

    @Override
    public VerificationResult verify() {
        this.enableKey = String.format(ENABLE_KEY_FORMAT, this.enableKey());
        if (!Boolean.parseBoolean(this.environment.getProperty(this.enableKey, "true"))) {
            return VerificationResult.compatible();
        }
        CompatibilityPredicate compatibilityPredicate = this.compatibilityPredicate();
        boolean matches = compatibilityPredicate.isCompatible();
        if (matches) {
            return VerificationResult.compatible();
        }
        return VerificationResult.notCompatible(this.errorDescription(), this.action());
    }

    public abstract CompatibilityPredicate compatibilityPredicate();

    public abstract String errorDescription();

    public abstract String action();

    public abstract String enableKey();
}

