/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.compatibility;

import com.alipay.sofa.boot.compatibility.CompatibilityNotMetException;
import com.alipay.sofa.boot.compatibility.CompatibilityVerifier;
import com.alipay.sofa.boot.compatibility.VerificationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeCompatibilityVerifier {
    private final List<CompatibilityVerifier> verifiers;

    public CompositeCompatibilityVerifier(List<CompatibilityVerifier> verifiers) {
        this.verifiers = verifiers;
    }

    public void verifyCompatibilities() {
        List<VerificationResult> errors = this.verifierErrors();
        if (errors.isEmpty()) {
            return;
        }
        String errorMessage = errors.stream().map(VerificationResult::toErrorMessage).collect(Collectors.toList()).toString();
        throw new CompatibilityNotMetException(errors, errorMessage);
    }

    private List<VerificationResult> verifierErrors() {
        ArrayList<VerificationResult> errors = new ArrayList<VerificationResult>();
        for (CompatibilityVerifier verifier : this.verifiers) {
            VerificationResult result = verifier.verify();
            if (!result.isNotCompatible()) continue;
            errors.add(result);
        }
        return errors;
    }
}

