/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.env;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Order(value=2147483547)
public class EnvironmentCustomizer
implements EnvironmentPostProcessor {
    private static final String PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE = "spring.autoconfigure.exclude";
    private static final List<String> SOFABOOT_EXCLUDE_AUTOCONFIGURATION_CLASSES = new ArrayList<String>();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.getPropertySources().get("sofaConfigurationProperties") != null) {
            return;
        }
        this.addSpringExcludeConfigurationPropertySource(environment);
        Properties defaultConfiguration = this.getSofaBootVersionProperties();
        defaultConfiguration.put("management.endpoints.web.exposure.include", "info, health, versions, components, beans, readiness, startup, triggerReadinessCallback");
        defaultConfiguration.put("management.endpoint.health.group.liveness.include", "livenessState,sofaBoot");
        PropertiesPropertySource propertySource = new PropertiesPropertySource("sofaConfigurationProperties", defaultConfiguration);
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setRequiredProperties(new String[]{"spring.application.name"});
    }

    protected Properties getSofaBootVersionProperties() {
        Properties properties = new Properties();
        String sofaBootVersion = this.getSofaBootVersion();
        sofaBootVersion = StringUtils.isEmpty((Object)sofaBootVersion) ? "" : sofaBootVersion;
        String sofaBootFormattedVersion = sofaBootVersion.isEmpty() ? "" : String.format(" (v%s)", sofaBootVersion);
        properties.setProperty("sofa-boot.version", sofaBootVersion);
        properties.setProperty("sofa-boot.formatted-version", sofaBootFormattedVersion);
        return properties;
    }

    protected String getSofaBootVersion() {
        return EnvironmentCustomizer.class.getPackage().getImplementationVersion();
    }

    protected void addSpringExcludeConfigurationPropertySource(ConfigurableEnvironment environment) {
        Binder binder = Binder.get((Environment)environment);
        ArrayList<String> excludeConfigs = new ArrayList<String>();
        List stringList = (List)binder.bind(PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE, String[].class).map(Arrays::asList).orElse(new ArrayList());
        excludeConfigs.addAll(SOFABOOT_EXCLUDE_AUTOCONFIGURATION_CLASSES);
        excludeConfigs.addAll(stringList);
        Properties properties = new Properties();
        properties.put(PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE, StringUtils.collectionToCommaDelimitedString(excludeConfigs));
        PropertiesPropertySource propertySource = new PropertiesPropertySource("sofaExcludeAutoConfigurationProperties", properties);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    static {
        SOFABOOT_EXCLUDE_AUTOCONFIGURATION_CLASSES.add("org.springframework.boot.actuate.autoconfigure.startup.StartupEndpointAutoConfiguration");
    }
}

