/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.listener;

import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.common.config.source.AbstractConfigSource;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class SofaConfigSourceSupportListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final int SOFA_BOOT_CONFIG_SOURCE_ORDER = -2147483633;
    private final AtomicBoolean registered = new AtomicBoolean();

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        this.registerSofaConfigs(event.getEnvironment());
    }

    private void registerSofaConfigs(final ConfigurableEnvironment environment) {
        if (this.registered.compareAndSet(false, true)) {
            SofaConfigs.addConfigSource((ConfigSource)new AbstractConfigSource(){

                public int getOrder() {
                    return -2147483633;
                }

                public String getName() {
                    return "SOFABootEnv";
                }

                public String doGetConfig(String key) {
                    return environment.getProperty(key);
                }

                public boolean hasKey(String key) {
                    return !StringUtils.isEmpty((Object)environment.getProperty(key));
                }
            });
        }
    }

    public int getOrder() {
        return -2147483633;
    }
}

