/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.startup;

import com.alipay.sofa.boot.startup.ChildrenStat;

public class BeanStat
extends ChildrenStat<BeanStat> {
    private static final String LAST_PREFIX = "\u2514\u2500";
    private static final String MIDDLE_PREFIX = "\u251c\u2500";
    private static final String INDENT_PREFIX = "\u2502   ";
    private static final String EMPTY_INDEX_PREFIX = "    ";
    private String beanClassName;
    private long beanRefreshStartTime;
    private long beanRefreshEndTime;
    private long refreshElapsedTime;
    private long realRefreshElapsedTime;
    private long initTime;
    private long afterPropertiesSetTime;
    private String interfaceType = null;
    private String beanType;
    private String extensionProperty;

    public void startRefresh() {
        this.beanRefreshStartTime = System.currentTimeMillis();
        this.setStartTime(this.beanRefreshStartTime);
    }

    public void finishRefresh() {
        this.beanRefreshEndTime = System.currentTimeMillis();
        this.refreshElapsedTime = this.beanRefreshEndTime - this.beanRefreshStartTime;
        long childRefreshTime = 0L;
        for (BeanStat child : this.getChildren()) {
            childRefreshTime += child.getRealRefreshElapsedTime();
        }
        this.realRefreshElapsedTime = this.refreshElapsedTime - childRefreshTime;
        this.setEndTime(this.beanRefreshEndTime);
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClassName = beanClassName;
    }

    public long getRefreshElapsedTime() {
        return this.refreshElapsedTime;
    }

    public void setRefreshElapsedTime(long refreshElapsedTime) {
        this.refreshElapsedTime = refreshElapsedTime;
    }

    public long getBeanRefreshStartTime() {
        return this.beanRefreshStartTime;
    }

    public void setBeanRefreshStartTime(long beanRefreshStartTime) {
        this.beanRefreshStartTime = beanRefreshStartTime;
    }

    public long getBeanRefreshEndTime() {
        return this.beanRefreshEndTime;
    }

    public void setBeanRefreshEndTime(long beanRefreshEndTime) {
        this.beanRefreshEndTime = beanRefreshEndTime;
    }

    public long getRealRefreshElapsedTime() {
        return this.realRefreshElapsedTime;
    }

    public void setRealRefreshElapsedTime(long realRefreshElapsedTime) {
        this.realRefreshElapsedTime = realRefreshElapsedTime;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public void setInitTime(long initTime) {
        this.initTime = initTime;
    }

    public long getAfterPropertiesSetTime() {
        return this.afterPropertiesSetTime;
    }

    public void setAfterPropertiesSetTime(long afterPropertiesSetTime) {
        this.afterPropertiesSetTime = afterPropertiesSetTime;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        this.beanType = beanType;
    }

    public String getExtensionProperty() {
        return this.extensionProperty;
    }

    public void setExtensionProperty(String extensionProperty) {
        this.extensionProperty = extensionProperty;
    }

    public String toString(String indent, boolean last) {
        StringBuilder rtn = new StringBuilder();
        rtn.append(indent).append(last ? LAST_PREFIX : MIDDLE_PREFIX).append(this.beanClassName).append("  [").append(this.refreshElapsedTime).append("ms]");
        int size = this.getChildren().size();
        for (int i = 0; i < size; ++i) {
            rtn.append("\n").append(((BeanStat)this.getChildren().get(i)).toString(indent + (last ? EMPTY_INDEX_PREFIX : INDENT_PREFIX), i == size - 1));
        }
        return rtn.toString();
    }

    public String toString() {
        return this.toString("", false);
    }
}

