/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;

public class SmartAnnotationUtils {
    public static <T extends Annotation> Collection<T> getAnnotations(AnnotatedElement element, Class<T> annotationType) {
        return SmartAnnotationUtils.getAnnotations(element, annotationType, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
    }

    public static <T extends Annotation> Collection<T> getAnnotations(AnnotatedElement element, Class<T> annotationType, MergedAnnotations.SearchStrategy searchStrategy) {
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)searchStrategy);
        List sofaServiceList = annotations.stream(annotationType).map(MergedAnnotation::synthesize).collect(Collectors.toList());
        if (sofaServiceList.size() > 1) {
            Object source = annotations.get(annotationType).getSource();
            return annotations.stream(annotationType).filter(annotation -> Objects.equals(annotation.getSource(), source)).map(MergedAnnotation::synthesize).collect(Collectors.toList());
        }
        return sofaServiceList;
    }
}

