/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.listener;

import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.common.config.source.AbstractConfigSource;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class SofaConfigSourceSupportListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final int SOFA_BOOT_CONFIG_SOURCE_ORDER = Integer.MAX_VALUE;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        final ConfigurableEnvironment environment = event.getEnvironment();
        SofaConfigs.addConfigSource((ConfigSource)new AbstractConfigSource(){

            public int getOrder() {
                return Integer.MAX_VALUE;
            }

            public String getName() {
                return "SOFABootEnv";
            }

            public String doGetConfig(String key) {
                return environment.getProperty(key);
            }

            public boolean hasKey(String key) {
                return !StringUtils.isEmpty((Object)environment.getProperty(key));
            }
        });
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

