/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.lb;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractLoadBalancer;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.PositiveAtomicCounter;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Extension(value="weightRoundRobin")
@Deprecated
public class WeightRoundRobinLoadBalancer
extends AbstractLoadBalancer {
    private final ConcurrentMap<String, PositiveAtomicCounter> sequences = new ConcurrentHashMap<String, PositiveAtomicCounter>();

    public WeightRoundRobinLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public ProviderInfo doSelect(SofaRequest request, List<ProviderInfo> providerInfos) {
        String key = this.getServiceKey(request);
        int length = providerInfos.size();
        int maxWeight = 0;
        int minWeight = Integer.MAX_VALUE;
        LinkedHashMap<ProviderInfo, IntegerWrapper> invokerToWeightMap = new LinkedHashMap<ProviderInfo, IntegerWrapper>();
        int weightSum = 0;
        for (ProviderInfo providerInfo : providerInfos) {
            int weight = this.getWeight(providerInfo);
            maxWeight = Math.max(maxWeight, weight);
            minWeight = Math.min(minWeight, weight);
            if (weight <= 0) continue;
            invokerToWeightMap.put(providerInfo, new IntegerWrapper(weight));
            weightSum += weight;
        }
        PositiveAtomicCounter sequence = (PositiveAtomicCounter)this.sequences.get(key);
        if (sequence == null) {
            this.sequences.putIfAbsent(key, new PositiveAtomicCounter());
            sequence = (PositiveAtomicCounter)this.sequences.get(key);
        }
        int currentSequence = sequence.getAndIncrement();
        if (maxWeight > 0 && minWeight < maxWeight) {
            int mod = currentSequence % weightSum;
            for (int i = 0; i < maxWeight; ++i) {
                for (Map.Entry each : invokerToWeightMap.entrySet()) {
                    ProviderInfo k = (ProviderInfo)each.getKey();
                    IntegerWrapper v = (IntegerWrapper)each.getValue();
                    if (mod == 0 && v.getValue() > 0) {
                        return k;
                    }
                    if (v.getValue() <= 0) continue;
                    v.decrement();
                    --mod;
                }
            }
        }
        return providerInfos.get(currentSequence % length);
    }

    private String getServiceKey(SofaRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getTargetAppName()).append("#").append(request.getMethodName());
        return builder.toString();
    }

    private static final class IntegerWrapper {
        private int value;

        public IntegerWrapper(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public void decrement() {
            --this.value;
        }

        public String toString() {
            return this.value + "";
        }
    }
}

