/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.jackson;

import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JacksonHelper {
    private ObjectMapper mapper = new ObjectMapper();
    private ConcurrentHashMap<ClassLoader, Map<String, JavaType[]>> requestClassCache = new ConcurrentHashMap();
    private ConcurrentHashMap<ClassLoader, Map<String, JavaType>> responseClassCache = new ConcurrentHashMap();

    public JavaType[] getReqClass(String service, String methodName) {
        String key = this.buildMethodKey(service, methodName);
        Type[] reqClassList = (Type[])this.getRequestCache().get(key);
        if (reqClassList == null) {
            String interfaceClass = ConfigUniqueNameGenerator.getInterfaceName(service);
            Class clazz = ClassUtils.forName(interfaceClass, true);
            this.loadClassToCache(key, clazz, methodName);
        }
        return this.getRequestCache().get(key);
    }

    private Map<String, JavaType[]> getRequestCache() {
        return this.requestClassCache.computeIfAbsent(ClassLoaderUtils.getCurrentClassLoader(), k -> new ConcurrentHashMap());
    }

    private Map<String, JavaType> getResponseCache() {
        return this.responseClassCache.computeIfAbsent(ClassLoaderUtils.getCurrentClassLoader(), k -> new ConcurrentHashMap());
    }

    public void clearCache(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        this.requestClassCache.remove(classLoader);
        this.responseClassCache.remove(classLoader);
    }

    public JavaType getResClass(String service, String methodName) {
        String key = service + "#" + methodName;
        JavaType reqType = this.getResponseCache().get(key);
        if (reqType == null) {
            String interfaceClass = ConfigUniqueNameGenerator.getInterfaceName(service);
            Class clazz = ClassUtils.forName(interfaceClass, true);
            this.loadClassToCache(key, clazz, methodName);
        }
        return this.getResponseCache().get(key);
    }

    private String buildMethodKey(String serviceName, String methodName) {
        return serviceName + "#" + methodName;
    }

    private void loadClassToCache(String key, Class clazz, String methodName) {
        Method[] methods;
        Method jsonMethod = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName()) || method.isBridge()) continue;
            jsonMethod = method;
            break;
        }
        if (jsonMethod == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020050014", clazz.getName(), methodName));
        }
        Type[] parameterTypes = jsonMethod.getGenericParameterTypes();
        JavaType[] javaTypes = new JavaType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaType javaType;
            javaTypes[i] = javaType = this.mapper.getTypeFactory().constructType(parameterTypes[i]);
        }
        this.getRequestCache().put(key, javaTypes);
        Type resType = jsonMethod.getGenericReturnType();
        if (resType == Void.TYPE) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020050015", "jackson", clazz.getName()));
        }
        JavaType resJavaType = this.mapper.getTypeFactory().constructType(resType);
        this.getResponseCache().put(key, resJavaType);
    }
}

