/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.jackson;

import com.alipay.sofa.common.config.ConfigKey;
import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.codec.jackson.JacksonConfigKeys;
import com.alipay.sofa.rpc.codec.jackson.JacksonHelper;
import com.alipay.sofa.rpc.common.utils.CodecUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

@Extension(value="json", code=12)
public class JacksonSerializer
extends AbstractSerializer {
    private ObjectMapper mapper = new ObjectMapper();
    private JacksonHelper jacksonHelper = new JacksonHelper();
    @Deprecated
    private static final String DESERIALIZATION_FEATURE_PREFIX = "sofa.rpc.codec.jackson.DeserializationFeature.";
    @Deprecated
    private static final String SERIALIZATION_FEATURE_PREFIX = "sofa.rpc.codec.jackson.SerializationFeature.";

    public JacksonSerializer() {
        Set<String> serFeatures = Arrays.stream(SerializationFeature.values()).map(Enum::name).collect(Collectors.toSet());
        Set<String> desFeatures = Arrays.stream(DeserializationFeature.values()).map(Enum::name).collect(Collectors.toSet());
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            boolean state;
            String enumName;
            if (key.startsWith(DESERIALIZATION_FEATURE_PREFIX) && desFeatures.contains(enumName = StringUtils.substringAfter(key, DESERIALIZATION_FEATURE_PREFIX))) {
                state = Boolean.parseBoolean(properties.getProperty(key));
                this.mapper.configure(DeserializationFeature.valueOf((String)enumName), state);
            }
            if (!key.startsWith(SERIALIZATION_FEATURE_PREFIX) || !serFeatures.contains(enumName = StringUtils.substringAfter(key, SERIALIZATION_FEATURE_PREFIX))) continue;
            state = Boolean.parseBoolean(properties.getProperty(key));
            this.mapper.configure(SerializationFeature.valueOf((String)enumName), state);
        }
        this.processJacksonSerFeature(this.mapper, serFeatures, desFeatures);
    }

    protected void processJacksonSerFeature(ObjectMapper objectMapper, Set<String> serFeatures, Set<String> desFeatures) {
        this.processSerializeFeatures(objectMapper, JacksonConfigKeys.JACKSON_SER_FEATURE_ENABLE_LIST, true, serFeatures);
        this.processSerializeFeatures(objectMapper, JacksonConfigKeys.JACKSON_SER_FEATURE_DISABLE_LIST, false, serFeatures);
        this.processDeserializeFeatures(objectMapper, JacksonConfigKeys.JACKSON_DES_FEATURE_ENABLE_LIST, true, desFeatures);
        this.processDeserializeFeatures(objectMapper, JacksonConfigKeys.JACKSON_DES_FEATURE_DISABLE_LIST, false, desFeatures);
    }

    private void processSerializeFeatures(ObjectMapper objectMapper, ConfigKey<String> key, boolean enable, Set<String> featureSet) {
        String serFeatureList = (String)SofaConfigs.getOrDefault(key);
        if (StringUtils.isBlank(serFeatureList)) {
            return;
        }
        Arrays.stream(serFeatureList.split(",")).filter(featureSet::contains).forEach(str -> objectMapper.configure(SerializationFeature.valueOf((String)str), enable));
    }

    private void processDeserializeFeatures(ObjectMapper objectMapper, ConfigKey<String> key, boolean enable, Set<String> featureSet) {
        String desFeatureList = (String)SofaConfigs.getOrDefault(key);
        if (StringUtils.isBlank(desFeatureList)) {
            return;
        }
        Arrays.stream(desFeatureList.split(",")).filter(featureSet::contains).forEach(str -> objectMapper.configure(DeserializationFeature.valueOf((String)str), enable));
    }

    @Override
    public AbstractByteBuf encode(Object object, Map<String, String> context) throws SofaRpcException {
        if (object instanceof SofaRequest) {
            return this.encodeSofaRequest((SofaRequest)object, context);
        }
        if (object instanceof SofaResponse) {
            return this.encodeSofaResponse((SofaResponse)object, context);
        }
        try {
            return new ByteArrayWrapperByteBuf(this.mapper.writeValueAsBytes(object));
        }
        catch (JsonProcessingException e) {
            throw this.buildSerializeError(e.getMessage());
        }
    }

    protected AbstractByteBuf encodeSofaRequest(SofaRequest sofaRequest, Map<String, String> context) throws SofaRpcException {
        Object[] args = sofaRequest.getMethodArgs();
        if (args.length == 1) {
            return this.encode(args[0], context);
        }
        return this.encode(args, context);
    }

    protected AbstractByteBuf encodeSofaResponse(SofaResponse sofaResponse, Map<String, String> context) throws SofaRpcException {
        Object appResponse;
        AbstractByteBuf byteBuf = sofaResponse.isError() ? this.encode(sofaResponse.getErrorMsg(), context) : ((appResponse = sofaResponse.getAppResponse()) instanceof Throwable ? this.encode(((Throwable)appResponse).getMessage(), context) : this.encode(appResponse, context));
        return byteBuf;
    }

    @Override
    public Object decode(AbstractByteBuf data, Class clazz, Map<String, String> context) throws SofaRpcException {
        Object result = null;
        if (clazz == null) {
            throw this.buildDeserializeError("class is null!");
        }
        try {
            result = this.mapper.readValue(data.array(), clazz);
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage());
        }
        return result;
    }

    @Override
    public void decode(AbstractByteBuf data, Object template, Map<String, String> context) throws SofaRpcException {
        if (template == null) {
            throw this.buildDeserializeError("template is null!");
        }
        if (template instanceof SofaRequest) {
            this.decodeSofaRequest(data, (SofaRequest)template, context);
        } else if (template instanceof SofaResponse) {
            this.decodeSofaResponse(data, (SofaResponse)template, context);
        } else {
            throw this.buildDeserializeError("Only support decode from SofaRequest and SofaResponse template");
        }
    }

    private void decodeSofaRequest(AbstractByteBuf data, SofaRequest sofaRequest, Map<String, String> head) {
        JavaType[] requestClassList;
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        sofaRequest.setTargetServiceUniqueName(targetService);
        String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetService);
        sofaRequest.setInterfaceName(interfaceName);
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        sofaRequest.setMethodName(methodName);
        String targetApp = head.remove("sofa_head_target_app");
        if (targetApp != null) {
            sofaRequest.setTargetAppName(targetApp);
        }
        this.parseRequestHeader("rpc_trace_context", head, sofaRequest);
        if (RpcInvokeContext.isBaggageEnable()) {
            this.parseRequestHeader("rpc_req_baggage", head, sofaRequest);
        }
        for (Map.Entry<String, String> entry : head.entrySet()) {
            sofaRequest.addRequestProp(entry.getKey(), entry.getValue());
        }
        JavaType[] requestClassListDecode = requestClassList = this.jacksonHelper.getReqClass(targetService, sofaRequest.getMethodName());
        if (genericServiceMap.containsKey(targetService)) {
            requestClassListDecode = this.jacksonHelper.getReqClass((String)genericServiceMap.get(targetService), sofaRequest.getMethodName());
        }
        Object[] reqList = this.decode(data, requestClassListDecode);
        sofaRequest.setMethodArgs(reqList);
        sofaRequest.setMethodArgSigs(this.parseArgSigs(requestClassList));
    }

    private Object[] decode(AbstractByteBuf data, JavaType[] clazzList) throws SofaRpcException {
        if (clazzList == null || clazzList.length == 0) {
            return new Object[0];
        }
        Object[] args = new Object[clazzList.length];
        try {
            JsonNode node = this.mapper.readTree(data.array());
            if (node.isArray()) {
                if (clazzList.length == 1) {
                    if (!clazzList[0].isCollectionLikeType() && !clazzList[0].isArrayType()) {
                        throw this.buildDeserializeError("JSON data can't be json array");
                    }
                    args[0] = this.mapper.readValue(node.traverse(), clazzList[0]);
                    return args;
                }
                if (clazzList.length != node.size()) {
                    throw this.buildDeserializeError("JSON Array size is not equal parameter size");
                }
                for (int i = 0; i < clazzList.length; ++i) {
                    args[i] = this.mapper.readValue(node.get(i).traverse(), clazzList[i]);
                }
            } else {
                if (clazzList.length > 1) {
                    throw this.buildDeserializeError("JSON data must be json array");
                }
                args[0] = this.mapper.readValue(node.traverse(), clazzList[0]);
            }
            return args;
        }
        catch (SofaRpcException e) {
            throw e;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    private String[] parseArgSigs(JavaType[] reqList) {
        ArrayList<String> argSigs = new ArrayList<String>();
        for (JavaType type : reqList) {
            argSigs.add(type.getRawClass().getName());
        }
        return argSigs.toArray(new String[argSigs.size()]);
    }

    private void parseRequestHeader(String key, Map<String, String> headerMap, SofaRequest sofaRequest) {
        HashMap<String, String> traceMap = new HashMap<String, String>(8);
        CodecUtils.treeCopyTo(key + ".", headerMap, traceMap, true);
        if (!traceMap.isEmpty()) {
            sofaRequest.addRequestProp(key, traceMap);
        }
    }

    private void decodeSofaResponse(AbstractByteBuf data, SofaResponse sofaResponse, Map<String, String> head) {
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        boolean isError = false;
        if ("true".equals(head.remove("sofa_head_response_error"))) {
            isError = true;
        }
        if (!head.isEmpty()) {
            sofaResponse.setResponseProps(head);
        }
        if (isError) {
            String errorMessage = (String)this.decode(data, String.class, head);
            if (errorMessage == null) {
                errorMessage = "";
            }
            sofaResponse.setErrorMsg(errorMessage);
        } else {
            Object result;
            JavaType respType = this.jacksonHelper.getResClass(targetService, methodName);
            try {
                result = this.mapper.readValue(data.array(), respType);
            }
            catch (IOException e) {
                throw this.buildDeserializeError(e.getMessage());
            }
            sofaResponse.setAppResponse(result);
        }
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    public void clearCache(ClassLoader classLoader) {
        this.jacksonHelper.clearCache(classLoader);
    }
}

