/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.sofahessian.serialize;

import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.sofa.rpc.codec.sofahessian.serialize.AbstractCustomHessianSerializer;
import com.alipay.sofa.rpc.codec.sofahessian.serialize.GenericCustomThrowableDeterminer;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayInputStream;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayOutputStream;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteStreamWrapperByteBuf;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class SofaResponseHessianSerializer
extends AbstractCustomHessianSerializer<SofaResponse> {
    public SofaResponseHessianSerializer(SerializerFactory serializerFactory, SerializerFactory genericSerializerFactory) {
        super(serializerFactory, genericSerializerFactory);
    }

    @Override
    public void decodeObjectByTemplate(AbstractByteBuf data, Map<String, String> context, SofaResponse template) throws SofaRpcException {
        try {
            boolean genericSerialize;
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            boolean bl = genericSerialize = context != null && this.isGenericResponse(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                input.setSerializerFactory(this.genericSerializerFactory);
                GenericObject genericObject = (GenericObject)input.readObject();
                template.setErrorMsg((String)genericObject.getField("errorMsg"));
                template.setAppResponse(GenericCustomThrowableDeterminer.judgeCustomThrowableForGenericObject(genericObject.getField("appResponse")));
                template.setResponseProps((Map)genericObject.getField("responseProps"));
            } else {
                input.setSerializerFactory(this.serializerFactory);
                SofaResponse tmp = (SofaResponse)input.readObject();
                template.setErrorMsg(tmp.getErrorMsg());
                template.setAppResponse(tmp.getAppResponse());
                template.setResponseProps(tmp.getResponseProps());
            }
            input.close();
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    @Override
    public SofaResponse decodeObject(AbstractByteBuf data, Map<String, String> context) throws SofaRpcException {
        try {
            Object object;
            boolean genericSerialize;
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            boolean bl = genericSerialize = context != null && this.isGenericResponse(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                input.setSerializerFactory(this.genericSerializerFactory);
                GenericObject genericObject = (GenericObject)input.readObject();
                SofaResponse sofaResponse = new SofaResponse();
                sofaResponse.setErrorMsg((String)genericObject.getField("errorMsg"));
                sofaResponse.setAppResponse(GenericCustomThrowableDeterminer.judgeCustomThrowableForGenericObject(genericObject.getField("appResponse")));
                sofaResponse.setResponseProps((Map)genericObject.getField("responseProps"));
                object = sofaResponse;
            } else {
                input.setSerializerFactory(this.serializerFactory);
                object = input.readObject();
            }
            input.close();
            return (SofaResponse)object;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    @Override
    public AbstractByteBuf encodeObject(SofaResponse sofaResponse, Map<String, String> context) {
        try {
            UnsafeByteArrayOutputStream byteArray = new UnsafeByteArrayOutputStream();
            Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
            output.setSerializerFactory(this.serializerFactory);
            output.writeObject((Object)sofaResponse);
            output.close();
            return new ByteStreamWrapperByteBuf(byteArray);
        }
        catch (IOException e) {
            throw this.buildSerializeError(e.getMessage(), e);
        }
    }
}

