/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProviderHelper {
    public static void compareGroup(ProviderGroup oldGroup, ProviderGroup newGroup, List<ProviderInfo> add, List<ProviderInfo> remove) {
        ProviderHelper.compareProviders(oldGroup.getProviderInfos(), newGroup.getProviderInfos(), add, remove);
    }

    public static void compareProviders(List<ProviderInfo> oldList, List<ProviderInfo> newList, List<ProviderInfo> add, List<ProviderInfo> remove) {
        if (CommonUtils.isEmpty(oldList)) {
            if (CommonUtils.isNotEmpty(newList)) {
                add.addAll(newList);
            }
        } else if (CommonUtils.isEmpty(newList)) {
            remove.addAll(oldList);
        } else if (CommonUtils.isNotEmpty(oldList)) {
            ArrayList<ProviderInfo> tmpList = new ArrayList<ProviderInfo>(newList);
            for (ProviderInfo oldProvider : oldList) {
                if (tmpList.contains(oldProvider)) {
                    tmpList.remove(oldProvider);
                    continue;
                }
                remove.add(oldProvider);
            }
            add.addAll(tmpList);
        }
    }

    public static void compareGroups(List<ProviderGroup> oldGroups, List<ProviderGroup> newGroups, List<ProviderInfo> add, List<ProviderInfo> remove) {
        block9: {
            block8: {
                if (!CommonUtils.isEmpty(oldGroups)) break block8;
                if (!CommonUtils.isNotEmpty(newGroups)) break block9;
                for (ProviderGroup newGroup : newGroups) {
                    add.addAll(newGroup.getProviderInfos());
                }
                break block9;
            }
            if (CommonUtils.isEmpty(newGroups)) {
                for (ProviderGroup oldGroup : oldGroups) {
                    remove.addAll(oldGroup.getProviderInfos());
                }
            } else if (CommonUtils.isNotEmpty(oldGroups)) {
                Map<String, List<ProviderInfo>> oldMap = ProviderHelper.convertToMap(oldGroups);
                Map<String, List<ProviderInfo>> mapTmp = ProviderHelper.convertToMap(newGroups);
                for (Map.Entry<String, List<ProviderInfo>> oldEntry : oldMap.entrySet()) {
                    String key = oldEntry.getKey();
                    List<ProviderInfo> oldList = oldEntry.getValue();
                    if (mapTmp.containsKey(key)) {
                        List<ProviderInfo> newList = mapTmp.remove(key);
                        ProviderHelper.compareProviders(oldList, newList, add, remove);
                        mapTmp.remove(key);
                        continue;
                    }
                    remove.addAll(oldList);
                }
                for (Map.Entry<String, List<ProviderInfo>> entry : mapTmp.entrySet()) {
                    add.addAll((Collection<ProviderInfo>)entry.getValue());
                }
            }
        }
    }

    private static Map<String, List<ProviderInfo>> convertToMap(List<ProviderGroup> providerGroups) {
        HashMap<String, List<ProviderInfo>> map = new HashMap<String, List<ProviderInfo>>(providerGroups.size());
        for (ProviderGroup providerGroup : providerGroups) {
            ArrayList<ProviderInfo> ps = (ArrayList<ProviderInfo>)map.get(providerGroup.getName());
            if (ps == null) {
                ps = new ArrayList<ProviderInfo>();
                map.put(providerGroup.getName(), ps);
            }
            ps.addAll(providerGroup.getProviderInfos());
        }
        return map;
    }

    public static boolean isEmpty(ProviderGroup group) {
        return group == null || group.isEmpty();
    }

    public static String toUrl(ProviderInfo providerInfo) {
        String uri = providerInfo.getProtocolType() + "://" + providerInfo.getHost() + ":" + providerInfo.getPort();
        uri = uri + StringUtils.trimToEmpty(providerInfo.getPath());
        StringBuilder sb = new StringBuilder();
        if (providerInfo.getRpcVersion() > 0) {
            sb.append("&").append("rpcVer").append("=").append(providerInfo.getRpcVersion());
        }
        if (providerInfo.getSerializationType() != null) {
            sb.append("&").append("serialization").append("=").append(providerInfo.getSerializationType());
        }
        for (Map.Entry<String, String> entry : providerInfo.getStaticAttrs().entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            uri = uri + sb.replace(0, 1, "?").toString();
        }
        return uri;
    }

    public static ProviderInfo toProviderInfo(String url) {
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.setOriginUrl(url);
        try {
            String address;
            String remainUrl;
            int protocolIndex = url.indexOf("://");
            if (protocolIndex > -1) {
                String protocol = url.substring(0, protocolIndex).toLowerCase();
                providerInfo.setProtocolType(protocol);
                remainUrl = url.substring(protocolIndex + 3);
            } else {
                remainUrl = url;
            }
            int addressIndex = remainUrl.indexOf("/");
            if (addressIndex > -1) {
                address = remainUrl.substring(0, addressIndex);
                remainUrl = remainUrl.substring(addressIndex);
            } else {
                int itfIndex = remainUrl.indexOf(63);
                if (itfIndex > -1) {
                    address = remainUrl.substring(0, itfIndex);
                    remainUrl = remainUrl.substring(itfIndex);
                } else {
                    address = remainUrl;
                    remainUrl = "";
                }
            }
            String[] ipAndPort = address.split(":", -1);
            providerInfo.setHost(ipAndPort[0]);
            if (ipAndPort.length > 1) {
                providerInfo.setPort(CommonUtils.parseInt(ipAndPort[1], providerInfo.getPort()));
            }
            if (remainUrl.length() > 0) {
                int itfIndex = remainUrl.indexOf(63);
                if (itfIndex > -1) {
                    String[] params;
                    String itf = remainUrl.substring(0, itfIndex);
                    providerInfo.setPath(itf);
                    remainUrl = remainUrl.substring(itfIndex + 1);
                    for (String parm : params = remainUrl.split("&", -1)) {
                        String[] kvpair = parm.split("=", -1);
                        if ("weight".equals(kvpair[0]) && StringUtils.isNotEmpty(kvpair[1])) {
                            int weight = CommonUtils.parseInt(kvpair[1], providerInfo.getWeight());
                            providerInfo.setWeight(weight);
                            providerInfo.setStaticAttr("weight", String.valueOf(weight));
                            continue;
                        }
                        if ("rpcVer".equals(kvpair[0]) && StringUtils.isNotEmpty(kvpair[1])) {
                            providerInfo.setRpcVersion(CommonUtils.parseInt(kvpair[1], providerInfo.getRpcVersion()));
                            continue;
                        }
                        if ("serialization".equals(kvpair[0]) && StringUtils.isNotEmpty(kvpair[1])) {
                            providerInfo.setSerializationType(kvpair[1]);
                            continue;
                        }
                        providerInfo.getStaticAttrs().put(kvpair[0], kvpair[1]);
                    }
                } else {
                    providerInfo.setPath(remainUrl);
                }
            } else {
                providerInfo.setPath("");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert url to provider, the wrong url is:" + url, e);
        }
        return providerInfo;
    }
}

