/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.log;

import com.alipay.sofa.rpc.common.utils.IOUtils;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.log.exception.LogCodeNotFoundException;
import com.alipay.sofa.rpc.log.exception.LogFormatException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class LogCodes {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCodes.class);
    protected static final String LOG = "RPC-%s: %s %s";
    protected static final Map<String, String> LOG_CODES = new ConcurrentHashMap<String, String>();
    protected static String NOTE = "";
    protected static final String NOTE_CODE = "99999";
    public static final String WARN_CANNOT_FOUND_SERVICE_4_SERVER = "01301";
    public static final String ERROR_SERVICE_INTERFACE_CANNOT_FOUND = "02001";
    public static final String ERROR_STANDALONE_APPNAME_CHECK_FAIL = "02002";
    public static final String ERROR_STANDALONE_REFER_GENERIC_CHECK_FAIL = "02003";
    public static final String ERROR_PROVIDER_TARGET_NULL = "02101";
    public static final String ERROR_PROVIDER_TARGET_REGISTERED = "02102";
    public static final String ERROR_PROXY_CONSUME_FAIL = "02103";
    public static final String ERROR_PROXY_PUBLISH_FAIL = "02104";
    public static final String ERROR_PROXY_PRE_UNPUBLISH_FAIL = "02105";
    public static final String ERROR_PROXY_POST_UNPUBLISH_FAIL = "02106";
    public static final String ERROR_PROXY_BINDING_CLASS_CANNOT_FOUND = "02107";
    public static final String ERROR_CANNOT_FOUND_SERVICE_4_CLIENT = "02301";
    public static final String ERROR_INVOKE_TIMEOUT = "02302";
    public static final String ERROR_INVOKE_TIMEOUT_NO_TARGET = "02303";
    public static final String ERROR_INVOKE_GET_CLIENT = "02304";
    public static final String ERROR_INVOKE_NO_TR_INVOKE_SERVICE = "02305";
    public static final String ERROR_NO_AVAILBLE_PROVIDER = "02306";
    public static final String ERROR_TRANSMIT_PARSE = "02307";
    public static final String ERROR_TRANSMIT_PARSE_APPNAME = "02308";
    public static final String ERROR_TRANSMIT_PARSE_CONFIG = "02309";
    public static final String ERROR_TRANSMIT_PARSE_URL = "02310";
    public static final String ERROR_TRANSMIT = "02311";
    public static final String ERROR_TARGET_URL_INVALID = "02312";
    public static final String ERROR_RESPONSE_FUTURE_NULL = "02401";
    public static final String ERROR_DECODE_REQ_CLASS_CANNOT_FOUND = "02402";
    public static final String ERROR_DECODE_RES_CLASS_CANNOT_FOUND = "02403";
    public static final String ERROR_DECODE_REQ_PROTOCOL_INVALID = "02404";
    public static final String ERROR_DECODE_RES_PROTOCOL_INVALID = "02405";
    public static final String ERROR_DECODE_CLASS_NOT_FOUND = "02406";
    public static final String ERROR_PROVIDER_TR_POOL_REJECTION = "02407";
    public static final String ERROR_PROVIDER_TR_POOL_FULL = "02408";
    public static final String ERROR_PROVIDER_TR_START = "02409";
    public static final String ERROR_PROVIDER_TR_STOP = "02410";
    public static final String ERROR_PROVIDER_SERVICE_CANNOT_FOUND = "02411";
    public static final String ERROR_PROVIDER_SERVICE_METHOD_CANNOT_FOUND = "02412";
    public static final String ERROR_PROVIDER_PROCESS = "02413";
    public static final String ERROR_INIT_METHOD_SPECIAL = "02414";
    public static final String ERROR_DECODE_REQ_SIG_CLASS_NOT_FOUND = "02415";
    public static final String LOCALFILEREGISTRY_FAIL_WRITEFILE = "02416";
    public static final String LOCALFILEREGISTRY_FAIL_READFILE = "02417";
    public static final String LOCALFILEREGISTRY_FAIL_READURL = "02418";
    public static final String LOCALFILEREGISTRY_FAIL_WRITECONFLICT = "02419";
    public static final String LOCALFILEREGISTRY_FAIL_INVOKE = "02420";
    public static final String ERROR_RESPONSE_FUTURE_NOT_CLEAR = "02421";
    public static final String ERROR_DISCARD_TIMEOUT_REQUEST = "02422";
    public static final String ERROR_DISCARD_TIMEOUT_RESPONSE = "02423";
    public static final String ERROR_PROXY_UNCOSUME_FAIL = "02424";
    public static final String ERROR_GUICE_MODULE_CANNOT_FOUND = "04001";
    public static final String ERROR_SOFA_FRAMEWORK_INVALID = "04002";
    public static final String ERROR_RPC_LOG_LOAD = "04003";
    public static final String ERROR_RPC_CONFIG_LOAD = "04004";
    public static final String ERROR_RPC_NETWORK_ADDRESS_LOAD = "04005";
    public static final String ERROR_APPLICATION_CONTEXT_NULL = "04006";
    public static final String ERROR_RPC_EVENT_HANDLE_ERROR = "04007";
    public static final String ERROR_SERVICE_PUBLISHING = "04101";
    public static final String ERROR_SERVICE_UNPUBLISHING = "04102";
    public static final String ERROR_OSGI_BUNDLECONTEXT_NULL = "04103";
    public static final String ERROR_OSGI_RESGISTER_SERVICE = "04104";
    public static final String ERROR_OSGI_UNRESGISTER_SERVICE = "04105";
    public static final String ERROR_ADDRESSING_CHAIN_EMPTY = "04201";
    public static final String ERROR_ROUTE_ADDRESS_HANDLER_NULL = "04202";
    public static final String ERROR_ROUTE_ADDRESS_HANDLER_REGISTERED = "04203";
    public static final String ERROR_ROUTE_ADDRESS_HANDLERS_NULL = "04204";
    public static final String ERROR_ROUTE_ADDRESS_PHASE_EXIST = "04205";
    public static final String ERROR_ROUTE_ADDRESS_SUBTOKEN_DECRY = "04206";
    public static final String ERROR_METRIC_REPORT_ERROR = "04207";
    public static final String ERROR_CE_SERVER_STARTED_LISTENER_ERROR = "04901";
    public static final String WARN_PROCESS_ADDRESS_WAIT = "03101";
    public static final String WARN_PROCESS_ADDRESS_WAIT_CONTINUE = "03102";
    public static final String WARN_PROCESS_PARSE_TARGET_METHOD = "03103";
    public static final String WARN_PROVIDER_CUT_CAUSE = "03401";
    public static final String WARN_PROVIDER_STOPPED = "03402";
    public static final String WARN_BINDING_ADDRESS_WAIT_TIME = "01101";
    public static final String WARN_CONSUMER_NOT_PERMIT = "01102";
    public static final String WARN_SUCCESS_BY_RETRY = "01201";
    public static final String WARN_DESERIALIZE_HEADER_ERROR = "01401";
    public static final String INFO_ACTIVATOR_START = "00001";
    public static final String INFO_ACTIVATOR_END = "00002";
    public static final String INFO_GET_CONFIG_DEFAULT_APP = "00004";
    public static final String INFO_GET_CONFIG_PROPERTY = "00005";
    public static final String INFO_TRANSMIT_INIT_FINISH = "00101";
    public static final String INFO_TRANSMIT_URLS_HANDLE = "00102";
    public static final String INFO_ADDRESS_WAIT_START = "00103";
    public static final String INFO_ADDRESS_WAIT_OVER = "00104";
    public static final String INFO_ROUTE_REGISTRY_PUB = "00201";
    public static final String INFO_ROUTE_REGISTRY_SUB = "00202";
    public static final String INFO_ROUTE_REGISTRY_UNPUB = "00203";
    public static final String INFO_ROUTE_REGISTRY_URLS_HANDLE = "00204";
    public static final String INFO_ROUTE_REGISTRY_PUB_START = "00205";
    public static final String INFO_ROUTE_REGISTRY_PUB_OVER = "00206";
    public static final String LOCALFILEREGISTRY_WRITE_FILEOVER = "00207";
    public static final String INFO_CONFREG_IGNORE = "00208";
    public static final String INFO_CONNECT_PUT_TO_ALIVE = "00209";
    public static final String INFO_CONNECT_PUT_TO_RETRY = "00210";
    public static final String INFO_CONNECT_RETRY_START = "00211";
    public static final String INFO_CONNECT_RETRY_SUCCES = "00212";
    public static final String INFO_CONNECT_RETRY_REMOVE = "00213";
    public static final String INFO_CONNECT_ALIVE_REMOVE = "00214";
    public static final String INFO_NEGOTIATION_RESULT = "00215";
    public static final String INFO_REGULATION_ABNORMAL = "00216";
    public static final String INFO_REGULATION_ABNORMAL_NOT_DEGRADE = "00217";
    public static final String INFO_ROUTE_REGISTRY_UNSUB = "00218";
    public static final String INFO_PROCESS_PROFILER_CLIENT_INVOKE = "00301";
    public static final String INFO_PROCESS_PROVIDER_TR_IN = "00302";
    public static final String INFO_PROCESS_PROVIDER_TR_OUT = "00303";
    public static final String INFO_SERVICE_METADATA_IS_NULL = "00304";
    public static final String ERROR_PROVIDER_GRPC_START = "05001";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String filename) {
        block10: {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = LogCodes.class.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(newClassLoader);
                String encoding = Locale.getDefault().toString();
                if (encoding == null || encoding.length() == 0) {
                    encoding = Locale.ENGLISH.toString();
                }
                String name = "sofa-rpc/" + filename + "_" + encoding + ".properties";
                if (LogCodes.class.getClassLoader().getResource(name) == null) {
                    name = "sofa-rpc/" + filename + "_" + Locale.ENGLISH.toString() + ".properties";
                }
                InputStreamReader reader = null;
                InputStream in = null;
                try {
                    Properties properties = new Properties();
                    in = LogCodes.class.getClassLoader().getResourceAsStream(name);
                    reader = new InputStreamReader(in, "UTF-8");
                    properties.load(reader);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        LOG_CODES.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    NOTE = LOG_CODES.get(NOTE_CODE) == null ? "" : LOG_CODES.get(NOTE_CODE);
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("\u521d\u59cb\u5316\u65e5\u5fd7\u7801\u5931\u8d25\uff1a" + name, e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(reader);
                    break block10;
                }
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(reader);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public static String getLog(String code) {
        if (!LOG_CODES.containsKey(code)) {
            throw new LogCodeNotFoundException(code);
        }
        try {
            return String.format(LOG, code, LOG_CODES.get(code), NOTE);
        }
        catch (Throwable e) {
            throw new LogFormatException(code);
        }
    }

    public static String getLiteLog(String codeOrMsg) {
        if (!LOG_CODES.containsKey(codeOrMsg)) {
            return codeOrMsg;
        }
        try {
            return LOG_CODES.get(codeOrMsg);
        }
        catch (Throwable e) {
            throw new LogFormatException(codeOrMsg);
        }
    }

    public static String getLog(String code, Object ... messages) {
        String message = LOG_CODES.get(code);
        if (message == null) {
            throw new LogCodeNotFoundException(code);
        }
        try {
            return String.format(LOG, code, MessageFormat.format(message, messages), NOTE);
        }
        catch (Throwable e) {
            throw new LogFormatException(code);
        }
    }

    public static String getLiteLog(String codeOrMsg, Object ... messages) {
        String message = LOG_CODES.get(codeOrMsg);
        if (message == null) {
            return MessageFormat.format(codeOrMsg, messages);
        }
        try {
            return MessageFormat.format(message, messages);
        }
        catch (Throwable e) {
            throw new LogFormatException(codeOrMsg);
        }
    }

    static {
        LogCodes.init("logcodes-common");
    }
}

