/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.module;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.module.Module;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ModuleFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleFactory.class);
    static final ConcurrentHashMap<String, Module> INSTALLED_MODULES = new ConcurrentHashMap();

    static boolean needLoad(String moduleLoadList, String moduleName) {
        String[] activatedModules = StringUtils.splitWithCommaOrSemicolon(moduleLoadList);
        boolean match = false;
        for (String activatedModule : activatedModules) {
            if ("*".equals(activatedModule)) {
                match = true;
                continue;
            }
            if (activatedModule.equals(moduleName)) {
                match = true;
                continue;
            }
            if (!match || !activatedModule.equals("!" + moduleName) && !activatedModule.equals("-" + moduleName)) continue;
            match = false;
            break;
        }
        return match;
    }

    public static void installModules() {
        ExtensionLoader<Module> loader = ExtensionLoaderFactory.getExtensionLoader(Module.class);
        String moduleLoadList = RpcConfigs.getStringValue("module.load.list");
        for (Map.Entry<String, ExtensionClass<Module>> o : loader.getAllExtensions().entrySet()) {
            String moduleName = o.getKey();
            Module module = o.getValue().getExtInstance();
            if (ModuleFactory.needLoad(moduleLoadList, moduleName)) {
                if (module.needLoad()) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Install Module: {}", moduleName);
                    }
                    module.install();
                    INSTALLED_MODULES.put(moduleName, module);
                    continue;
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("The module " + moduleName + " does not need to be loaded.");
                continue;
            }
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("The module " + moduleName + " is not in the module load list.");
        }
    }

    public static void uninstallModules() {
        for (Map.Entry<String, Module> o : INSTALLED_MODULES.entrySet()) {
            String moduleName = o.getKey();
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Uninstall Module: {}", moduleName);
                }
                o.getValue().uninstall();
                INSTALLED_MODULES.remove(moduleName);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Error when uninstall module " + moduleName, e);
            }
        }
    }

    public static void uninstallModule(String moduleName) {
        block3: {
            Module module = INSTALLED_MODULES.get(moduleName);
            if (module != null) {
                try {
                    module.uninstall();
                    INSTALLED_MODULES.remove(moduleName);
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Error when uninstall module " + moduleName, e);
                }
            }
        }
    }
}

