/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.zk.ZookeeperConfigObserver;
import com.alipay.sofa.rpc.registry.zk.ZookeeperOverrideObserver;
import com.alipay.sofa.rpc.registry.zk.ZookeeperProviderObserver;
import com.alipay.sofa.rpc.registry.zk.ZookeeperRegistryHelper;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;

@Extension(value="zookeeper")
public class ZookeeperRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperRegistry.class);
    public static final String PARAM_PREFER_LOCAL_FILE = "preferLocalFile";
    public static final String PARAM_CREATE_EPHEMERAL = "createEphemeral";
    private static final byte[] PROVIDER_OFFLINE = new byte[]{0};
    private static final byte[] PROVIDER_ONLINE = new byte[]{1};
    private CuratorFramework zkClient;
    private String rootPath;
    private boolean preferLocalFile = false;
    private boolean ephemeralNode = true;
    private ZookeeperConfigObserver configObserver;
    private ZookeeperOverrideObserver overrideObserver;
    private ZookeeperProviderObserver providerObserver;
    private Map<ProviderConfig, List<String>> providerUrls = new ConcurrentHashMap<ProviderConfig, List<String>>();
    private Map<ConsumerConfig, String> consumerUrls = new ConcurrentHashMap<ConsumerConfig, String>();
    private static final ConcurrentHashMap<String, PathChildrenCache> INTERFACE_CONFIG_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, PathChildrenCache> INTERFACE_OVERRIDE_CACHE = new ConcurrentHashMap();

    protected ZookeeperRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    @Override
    public synchronized void init() {
        String address;
        if (this.zkClient != null) {
            return;
        }
        String addressInput = this.registryConfig.getAddress();
        if (StringUtils.isEmpty(addressInput)) {
            throw new SofaRpcRuntimeException("Address of zookeeper registry is empty.");
        }
        int idx = addressInput.indexOf("/");
        if (idx > 0) {
            address = addressInput.substring(0, idx);
            this.rootPath = addressInput.substring(idx);
            if (!this.rootPath.endsWith("/")) {
                this.rootPath = this.rootPath + "/";
            }
        } else {
            address = addressInput;
            this.rootPath = "/";
        }
        this.preferLocalFile = !CommonUtils.isFalse(this.registryConfig.getParameter(PARAM_PREFER_LOCAL_FILE));
        boolean bl = this.ephemeralNode = !CommonUtils.isFalse(this.registryConfig.getParameter(PARAM_CREATE_EPHEMERAL));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Init ZookeeperRegistry with address {}, root path is {}. preferLocalFile:{}, ephemeralNode:{}", address, this.rootPath, this.preferLocalFile, this.ephemeralNode);
        }
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        this.zkClient = CuratorFrameworkFactory.builder().connectString(address).sessionTimeoutMs(this.registryConfig.getConnectTimeout() * 3).connectionTimeoutMs(this.registryConfig.getConnectTimeout()).canBeReadOnly(false).retryPolicy((RetryPolicy)retryPolicy).defaultData(null).build();
    }

    @Override
    public synchronized boolean start() {
        if (this.zkClient == null) {
            LOGGER.warn("Start zookeeper registry must be do init first!");
            return false;
        }
        if (this.zkClient.getState() == CuratorFrameworkState.STARTED) {
            return true;
        }
        try {
            this.zkClient.start();
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException("Failed to start zookeeper zkClient", e);
        }
        return this.zkClient.getState() == CuratorFrameworkState.STARTED;
    }

    @Override
    public void destroy() {
        if (this.zkClient != null && this.zkClient.getState() == CuratorFrameworkState.STARTED) {
            this.zkClient.close();
        }
        this.providerUrls.clear();
        this.consumerUrls.clear();
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        hook.postDestroy();
        this.destroy();
        hook.postDestroy();
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (config.isRegister()) {
            try {
                List<String> urls = ZookeeperRegistryHelper.convertProviderToUrls(config);
                if (CommonUtils.isNotEmpty(urls)) {
                    String providerPath = ZookeeperRegistryHelper.buildProviderPath(this.rootPath, config);
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00205", providerPath));
                    }
                    for (String url : urls) {
                        url = URLEncoder.encode(url, "UTF-8");
                        String providerUrl = providerPath + "/" + url;
                        ((ACLBackgroundPathAndBytesable)this.getAndCheckZkClient().create().creatingParentContainersIfNeeded().withMode(this.ephemeralNode ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT)).forPath(providerUrl, config.isDynamic() ? PROVIDER_ONLINE : PROVIDER_OFFLINE);
                        if (!LOGGER.isInfoEnabled(appName)) continue;
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00201", providerUrl));
                    }
                    this.providerUrls.put(config, urls);
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00206", providerPath));
                    }
                }
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to register provider to zookeeperRegistry!", e);
            }
        }
        if (config.isSubscribe() && !INTERFACE_CONFIG_CACHE.containsKey(ZookeeperRegistryHelper.buildConfigPath(this.rootPath, config))) {
            this.subscribeConfig(config, config.getConfigListener());
        }
    }

    protected void subscribeConfig(final AbstractInterfaceConfig config, ConfigListener listener) {
        try {
            if (this.configObserver == null) {
                this.configObserver = new ZookeeperConfigObserver();
            }
            this.configObserver.addConfigListener(config, listener);
            final String configPath = ZookeeperRegistryHelper.buildConfigPath(this.rootPath, config);
            PathChildrenCache pathChildrenCache = new PathChildrenCache(this.zkClient, configPath, true);
            pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                public void childEvent(CuratorFramework client1, PathChildrenCacheEvent event) throws Exception {
                    if (LOGGER.isDebugEnabled(config.getAppName())) {
                        LOGGER.debug("Receive zookeeper event: type=[" + event.getType() + "]");
                    }
                    switch (event.getType()) {
                        case CHILD_ADDED: {
                            ZookeeperRegistry.this.configObserver.addConfig(config, configPath, event.getData());
                            break;
                        }
                        case CHILD_REMOVED: {
                            ZookeeperRegistry.this.configObserver.removeConfig(config, configPath, event.getData());
                            break;
                        }
                        case CHILD_UPDATED: {
                            ZookeeperRegistry.this.configObserver.updateConfig(config, configPath, event.getData());
                            break;
                        }
                    }
                }
            });
            pathChildrenCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
            INTERFACE_CONFIG_CACHE.put(configPath, pathChildrenCache);
            this.configObserver.updateConfigAll(config, configPath, pathChildrenCache.getCurrentData());
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException("Failed to subscribe provider config from zookeeperRegistry!", e);
        }
    }

    protected void subscribeOverride(final ConsumerConfig config, ConfigListener listener) {
        try {
            if (this.overrideObserver == null) {
                this.overrideObserver = new ZookeeperOverrideObserver();
            }
            this.overrideObserver.addConfigListener(config, listener);
            final String overridePath = ZookeeperRegistryHelper.buildOverridePath(this.rootPath, config);
            final AbstractInterfaceConfig registerConfig = this.getRegisterConfig(config);
            PathChildrenCache pathChildrenCache = new PathChildrenCache(this.zkClient, overridePath, true);
            pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                public void childEvent(CuratorFramework client1, PathChildrenCacheEvent event) throws Exception {
                    if (LOGGER.isDebugEnabled(config.getAppName())) {
                        LOGGER.debug("Receive zookeeper event: type=[" + event.getType() + "]");
                    }
                    switch (event.getType()) {
                        case CHILD_ADDED: {
                            ZookeeperRegistry.this.overrideObserver.addConfig(config, overridePath, event.getData());
                            break;
                        }
                        case CHILD_REMOVED: {
                            ZookeeperRegistry.this.overrideObserver.removeConfig(config, overridePath, event.getData(), registerConfig);
                            break;
                        }
                        case CHILD_UPDATED: {
                            ZookeeperRegistry.this.overrideObserver.updateConfig(config, overridePath, event.getData());
                            break;
                        }
                    }
                }
            });
            pathChildrenCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
            INTERFACE_OVERRIDE_CACHE.put(overridePath, pathChildrenCache);
            this.overrideObserver.updateConfigAll(config, overridePath, pathChildrenCache.getCurrentData());
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException("Failed to subscribe provider config from zookeeperRegistry!", e);
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        block12: {
            block11: {
                String appName = config.getAppName();
                if (!this.registryConfig.isRegister()) {
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
                    }
                    return;
                }
                if (config.isRegister()) {
                    try {
                        List<String> urls = this.providerUrls.remove(config);
                        if (CommonUtils.isNotEmpty(urls)) {
                            String providerPath = ZookeeperRegistryHelper.buildProviderPath(this.rootPath, config);
                            for (String url : urls) {
                                url = URLEncoder.encode(url, "UTF-8");
                                this.getAndCheckZkClient().delete().forPath(providerPath + "/" + url);
                            }
                            if (LOGGER.isInfoEnabled(appName)) {
                                LOGGER.infoWithApp(appName, LogCodes.getLog("00203", providerPath, "1"));
                            }
                        }
                    }
                    catch (Exception e) {
                        if (RpcRunningState.isShuttingDown()) break block11;
                        throw new SofaRpcRuntimeException("Failed to unregister provider to zookeeperRegistry!", e);
                    }
                }
            }
            if (config.isSubscribe()) {
                try {
                    this.configObserver.removeConfigListener(config);
                    this.overrideObserver.removeConfigListener(config);
                }
                catch (Exception e) {
                    if (RpcRunningState.isShuttingDown()) break block12;
                    throw new SofaRpcRuntimeException("Failed to unsubscribe provider config from zookeeperRegistry!", e);
                }
            }
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            this.unRegister(config);
        }
    }

    @Override
    public List<ProviderGroup> subscribe(final ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return null;
        }
        if (config.isRegister()) {
            try {
                String consumerPath = ZookeeperRegistryHelper.buildConsumerPath(this.rootPath, config);
                String url = ZookeeperRegistryHelper.convertConsumerToUrl(config);
                String encodeUrl = URLEncoder.encode(url, "UTF-8");
                ((ACLBackgroundPathAndBytesable)this.getAndCheckZkClient().create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(consumerPath + "/" + encodeUrl);
                this.consumerUrls.put(config, url);
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to register consumer to zookeeperRegistry!", e);
            }
        }
        if (config.isSubscribe()) {
            if (!INTERFACE_CONFIG_CACHE.containsKey(ZookeeperRegistryHelper.buildConfigPath(this.rootPath, config))) {
                this.subscribeConfig(config, config.getConfigListener());
            }
            if (!INTERFACE_OVERRIDE_CACHE.containsKey(ZookeeperRegistryHelper.buildOverridePath(this.rootPath, config))) {
                this.subscribeOverride(config, config.getConfigListener());
            }
            try {
                if (this.providerObserver == null) {
                    this.providerObserver = new ZookeeperProviderObserver();
                }
                final String providerPath = ZookeeperRegistryHelper.buildProviderPath(this.rootPath, config);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00202", providerPath));
                }
                ProviderInfoListener providerInfoListener = config.getProviderInfoListener();
                this.providerObserver.addProviderListener(config, providerInfoListener);
                PathChildrenCache pathChildrenCache = new PathChildrenCache(this.zkClient, providerPath, true);
                pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                    public void childEvent(CuratorFramework client1, PathChildrenCacheEvent event) throws Exception {
                        if (LOGGER.isDebugEnabled(config.getAppName())) {
                            LOGGER.debugWithApp(config.getAppName(), "Receive zookeeper event: type=[" + event.getType() + "]");
                        }
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                ZookeeperRegistry.this.providerObserver.addProvider(config, providerPath, event.getData());
                                break;
                            }
                            case CHILD_REMOVED: {
                                ZookeeperRegistry.this.providerObserver.removeProvider(config, providerPath, event.getData());
                                break;
                            }
                            case CHILD_UPDATED: {
                                ZookeeperRegistry.this.providerObserver.updateProvider(config, providerPath, event.getData());
                                break;
                            }
                        }
                    }
                });
                pathChildrenCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
                List<ProviderInfo> providerInfos = ZookeeperRegistryHelper.convertUrlsToProviders(providerPath, pathChildrenCache.getCurrentData());
                List<ProviderInfo> matchProviders = ZookeeperRegistryHelper.matchProviderInfos(config, providerInfos);
                return Collections.singletonList(new ProviderGroup().addAll(matchProviders));
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to subscribe provider from zookeeperRegistry!", e);
            }
        }
        return null;
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        block11: {
            block9: {
                if (config.isRegister()) {
                    try {
                        String url = this.consumerUrls.remove(config);
                        if (url != null) {
                            String consumerPath = ZookeeperRegistryHelper.buildConsumerPath(this.rootPath, config);
                            url = URLEncoder.encode(url, "UTF-8");
                            this.getAndCheckZkClient().delete().forPath(consumerPath + "/" + url);
                        }
                    }
                    catch (Exception e) {
                        if (RpcRunningState.isShuttingDown()) break block9;
                        throw new SofaRpcRuntimeException("Failed to unregister consumer to zookeeperRegistry!", e);
                    }
                }
            }
            if (config.isSubscribe()) {
                block10: {
                    try {
                        this.providerObserver.removeProviderListener(config);
                    }
                    catch (Exception e) {
                        if (RpcRunningState.isShuttingDown()) break block10;
                        throw new SofaRpcRuntimeException("Failed to unsubscribe provider from zookeeperRegistry!", e);
                    }
                }
                try {
                    this.configObserver.removeConfigListener(config);
                }
                catch (Exception e) {
                    if (RpcRunningState.isShuttingDown()) break block11;
                    throw new SofaRpcRuntimeException("Failed to unsubscribe consumer config from zookeeperRegistry!", e);
                }
            }
        }
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            this.unSubscribe(config);
        }
    }

    protected CuratorFramework getZkClient() {
        return this.zkClient;
    }

    private CuratorFramework getAndCheckZkClient() {
        if (this.zkClient == null || this.zkClient.getState() != CuratorFrameworkState.STARTED) {
            throw new SofaRpcRuntimeException("Zookeeper client is not available");
        }
        return this.zkClient;
    }

    private AbstractInterfaceConfig getRegisterConfig(ConsumerConfig config) {
        String url = ZookeeperRegistryHelper.convertConsumerToUrl(config);
        String addr = url.substring(0, url.indexOf("?"));
        for (Map.Entry<ConsumerConfig, String> consumerUrl : this.consumerUrls.entrySet()) {
            if (!consumerUrl.getValue().contains(addr)) continue;
            return consumerUrl.getKey();
        }
        return null;
    }
}

