/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;

public class SslContextBuilder {
    public static final boolean SSL = System.getProperty("ssl") != null;

    public static SslContext build() {
        SslContext sslCtx;
        try {
            if (SSL) {
                SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                sslCtx = io.netty.handler.ssl.SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            } else {
                sslCtx = null;
            }
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException("Failed to start http/2 server!", e);
        }
        return sslCtx;
    }
}

