/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.dubbo;

import com.alibaba.dubbo.config.AbstractInterfaceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alipay.sofa.rpc.bootstrap.dubbo.DubboSingleton;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;

public class DubboConvertor {
    public static void copyRegistries(com.alipay.sofa.rpc.config.AbstractInterfaceConfig sofaConfig, AbstractInterfaceConfig dubboConfig) {
        List<com.alipay.sofa.rpc.config.RegistryConfig> registryConfigs = sofaConfig.getRegistry();
        if (CommonUtils.isNotEmpty(registryConfigs)) {
            ArrayList<RegistryConfig> dubboRegistryConfigs = new ArrayList<RegistryConfig>();
            for (com.alipay.sofa.rpc.config.RegistryConfig registryConfig : registryConfigs) {
                RegistryConfig dubboRegistryConfig = (RegistryConfig)DubboSingleton.REGISTRY_MAP.get(registryConfig);
                if (dubboRegistryConfig == null) {
                    dubboRegistryConfig = new RegistryConfig();
                    DubboConvertor.copyRegistryFields(registryConfig, dubboRegistryConfig);
                    RegistryConfig old = DubboSingleton.REGISTRY_MAP.putIfAbsent(registryConfig, dubboRegistryConfig);
                    if (old != null) {
                        dubboRegistryConfig = old;
                    }
                }
                dubboRegistryConfigs.add(dubboRegistryConfig);
            }
            dubboConfig.setRegistries(dubboRegistryConfigs);
        }
    }

    public static void copyRegistryFields(com.alipay.sofa.rpc.config.RegistryConfig sofaRegistryConfig, RegistryConfig dubboRegistryConfig) {
        dubboRegistryConfig.setAddress(sofaRegistryConfig.getAddress());
        dubboRegistryConfig.setProtocol(sofaRegistryConfig.getProtocol());
        dubboRegistryConfig.setRegister(Boolean.valueOf(sofaRegistryConfig.isRegister()));
        dubboRegistryConfig.setSubscribe(Boolean.valueOf(sofaRegistryConfig.isSubscribe()));
        dubboRegistryConfig.setAddress(sofaRegistryConfig.getAddress());
        dubboRegistryConfig.setTimeout(Integer.valueOf(sofaRegistryConfig.getTimeout()));
        dubboRegistryConfig.setId(sofaRegistryConfig.getId());
        dubboRegistryConfig.setParameters(sofaRegistryConfig.getParameters());
    }
}

