/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderStatus;
import com.alipay.sofa.rpc.common.RpcConfigs;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProviderInfo
implements Serializable {
    private static final long serialVersionUID = -6438690329875954051L;
    private transient String originUrl;
    private String protocolType = RpcConfigs.getStringValue("default.protocol");
    private String host;
    private int port = 80;
    private String path;
    private String serializationType;
    private int rpcVersion;
    private volatile transient int weight = RpcConfigs.getIntValue("provider.weight");
    private volatile transient ProviderStatus status = ProviderStatus.AVAILABLE;
    private final ConcurrentMap<String, String> staticAttrs = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<String, Object> dynamicAttrs = new ConcurrentHashMap<String, Object>();

    public ProviderInfo() {
    }

    public ProviderInfo(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ProviderInfo(String host, int port, String originUrl) {
        this.host = host;
        this.port = port;
        this.originUrl = originUrl;
    }

    @Deprecated
    public static ProviderInfo valueOf(String url) {
        return ProviderHelper.toProviderInfo(url);
    }

    @Deprecated
    public String toUrl() {
        return ProviderHelper.toUrl(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProviderInfo that = (ProviderInfo)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.rpcVersion != that.rpcVersion) {
            return false;
        }
        if (this.protocolType != null ? !this.protocolType.equals(that.protocolType) : that.protocolType != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return !(this.serializationType != null ? !this.serializationType.equals(that.serializationType) : that.serializationType != null);
    }

    public int hashCode() {
        int result = this.protocolType != null ? this.protocolType.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.serializationType != null ? this.serializationType.hashCode() : 0);
        result = 31 * result + this.rpcVersion;
        return result;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public ProviderInfo setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
        return this;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public ProviderInfo setProtocolType(String protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ProviderInfo setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ProviderInfo setPort(int port) {
        this.port = port;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public ProviderInfo setPath(String path) {
        this.path = path;
        return this;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public ProviderInfo setSerializationType(String serializationType) {
        this.serializationType = serializationType;
        return this;
    }

    public int getWeight() {
        ProviderStatus status = this.getStatus();
        if (status == ProviderStatus.WARMING_UP) {
            try {
                Integer warmUpWeight = (Integer)this.getDynamicAttr("warmupWeight");
                if (warmUpWeight != null) {
                    return warmUpWeight;
                }
            }
            catch (Exception e) {
                return this.weight;
            }
        }
        return this.weight;
    }

    public ProviderInfo setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public int getRpcVersion() {
        return this.rpcVersion;
    }

    public ProviderInfo setRpcVersion(int rpcVersion) {
        this.rpcVersion = rpcVersion;
        return this;
    }

    public ProviderStatus getStatus() {
        if (this.status == ProviderStatus.WARMING_UP && System.currentTimeMillis() > (Long)this.getDynamicAttr("warmupEndTime")) {
            this.status = ProviderStatus.AVAILABLE;
            this.setDynamicAttr("warmupEndTime", null);
        }
        return this.status;
    }

    public ProviderInfo setStatus(ProviderStatus status) {
        this.status = status;
        return this;
    }

    public ConcurrentMap<String, String> getStaticAttrs() {
        return this.staticAttrs;
    }

    public ProviderInfo setStaticAttrs(Map<String, String> staticAttrs) {
        this.staticAttrs.clear();
        this.staticAttrs.putAll(staticAttrs);
        return this;
    }

    public ConcurrentMap<String, Object> getDynamicAttrs() {
        return this.dynamicAttrs;
    }

    public ProviderInfo setDynamicAttrs(Map<String, Object> dynamicAttrs) {
        this.dynamicAttrs.clear();
        this.dynamicAttrs.putAll(dynamicAttrs);
        return this;
    }

    public String getStaticAttr(String staticAttrKey) {
        return (String)this.staticAttrs.get(staticAttrKey);
    }

    public ProviderInfo setStaticAttr(String staticAttrKey, String staticAttrValue) {
        if (staticAttrValue == null) {
            this.staticAttrs.remove(staticAttrKey);
        } else {
            this.staticAttrs.put(staticAttrKey, staticAttrValue);
        }
        return this;
    }

    public Object getDynamicAttr(String dynamicAttrKey) {
        return this.dynamicAttrs.get(dynamicAttrKey);
    }

    public ProviderInfo setDynamicAttr(String dynamicAttrKey, Object dynamicAttrValue) {
        if (dynamicAttrValue == null) {
            this.dynamicAttrs.remove(dynamicAttrKey);
        } else {
            this.dynamicAttrs.put(dynamicAttrKey, dynamicAttrValue);
        }
        return this;
    }

    public String toString() {
        return this.originUrl == null ? this.host + ":" + this.port : this.originUrl;
    }

    public String getAttr(String key) {
        String val = (String)this.dynamicAttrs.get(key);
        return val == null ? (String)this.staticAttrs.get(key) : val;
    }
}

