/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.router;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AddressHolder;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.Router;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import java.util.List;

@Extension(value="mesh", order=-19000)
@AutoActive(consumerSide=true)
public class MeshRouter
extends Router {
    public static final String RPC_MESH_ROUTER = "MESH";
    protected ConsumerBootstrap consumerBootstrap;

    @Override
    public void init(ConsumerBootstrap consumerBootstrap) {
        this.consumerBootstrap = consumerBootstrap;
    }

    @Override
    public boolean needToLoad(ConsumerBootstrap consumerBootstrap) {
        ConsumerConfig consumerConfig = consumerBootstrap.getConsumerConfig();
        boolean isDirect = StringUtils.isNotBlank(consumerConfig.getDirectUrl());
        List<RegistryConfig> registrys = consumerConfig.getRegistry();
        boolean isMesh = false;
        if (registrys != null) {
            for (RegistryConfig registry : registrys) {
                if (!registry.getProtocol().equalsIgnoreCase("mesh")) continue;
                isMesh = true;
                break;
            }
        }
        boolean isBolt = consumerConfig.getProtocol().equalsIgnoreCase("bolt");
        return !isDirect && isMesh && isBolt;
    }

    @Override
    public List<ProviderInfo> route(SofaRequest request, List<ProviderInfo> providerInfos) {
        AddressHolder addressHolder = this.consumerBootstrap.getCluster().getAddressHolder();
        if (addressHolder != null) {
            List<ProviderInfo> current = addressHolder.getProviderInfos("_DEFAULT");
            if (providerInfos != null) {
                providerInfos.addAll(current);
            } else {
                providerInfos = current;
            }
        }
        this.recordRouterWay(RPC_MESH_ROUTER);
        return providerInfos;
    }
}

