/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProviderInvoker<T>
extends FilterInvoker {
    private final ProviderConfig<T> providerConfig;

    public ProviderInvoker(ProviderConfig<T> providerConfig) {
        super(providerConfig);
        this.providerConfig = providerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SofaResponse invoke(SofaRequest request) throws SofaRpcException {
        SofaResponse sofaResponse = new SofaResponse();
        long startTime = RpcRuntimeContext.now();
        try {
            Method method = request.getMethod();
            if (method == null) {
                throw new SofaRpcException(170, "Need decode method first!");
            }
            Object result = method.invoke(this.providerConfig.getRef(), request.getMethodArgs());
            sofaResponse.setAppResponse(result);
        }
        catch (IllegalArgumentException e) {
            sofaResponse.setErrorMsg(e.getMessage());
        }
        catch (IllegalAccessException e) {
            sofaResponse.setErrorMsg(e.getMessage());
        }
        catch (InvocationTargetException e) {
            sofaResponse.setAppResponse(e.getCause());
        }
        finally {
            if (RpcInternalContext.isAttachmentEnable()) {
                long endTime = RpcRuntimeContext.now();
                RpcInternalContext.getContext().setAttachment("_impl_elapse", endTime - startTime);
            }
        }
        return sofaResponse;
    }
}

