/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.hystrix;

import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.hystrix.DefaultFallbackFactory;
import com.alipay.sofa.rpc.hystrix.DefaultSetterFactory;
import com.alipay.sofa.rpc.hystrix.FallbackFactory;
import com.alipay.sofa.rpc.hystrix.SetterFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SofaHystrixConfig {
    private static final Map<ConsumerConfig, FallbackFactory> FALLBACK_FACTORY_MAPPING = new ConcurrentHashMap<ConsumerConfig, FallbackFactory>();
    private static final Map<ConsumerConfig, SetterFactory> SETTER_FACTORY_MAPPING = new ConcurrentHashMap<ConsumerConfig, SetterFactory>();

    public static void registerFallback(ConsumerConfig consumerConfig, Object fallback) {
        FALLBACK_FACTORY_MAPPING.put(consumerConfig, new DefaultFallbackFactory<Object>(fallback));
    }

    public static void registerFallbackFactory(ConsumerConfig consumerConfig, FallbackFactory fallbackFactory) {
        FALLBACK_FACTORY_MAPPING.put(consumerConfig, fallbackFactory);
    }

    public static void registerSetterFactory(ConsumerConfig consumerConfig, SetterFactory setterFactory) {
        SETTER_FACTORY_MAPPING.put(consumerConfig, setterFactory);
    }

    public static FallbackFactory loadFallbackFactory(ConsumerConfig consumerConfig) {
        return FALLBACK_FACTORY_MAPPING.get(consumerConfig);
    }

    public static SetterFactory loadSetterFactory(ConsumerConfig consumerConfig) {
        SetterFactory setterFactory = SETTER_FACTORY_MAPPING.get(consumerConfig);
        if (setterFactory != null) {
            return setterFactory;
        }
        return new DefaultSetterFactory();
    }
}

