/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul.common;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.registry.consul.common.ConsulURL;
import com.alipay.sofa.rpc.registry.consul.model.ThrallRoleType;
import java.util.regex.Pattern;

public class ConsulURLUtils {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");

    private ConsulURLUtils() {
    }

    public static boolean isValidAddress(String address) {
        String[] ipAndHost = StringUtils.split(address, ":");
        return ipAndHost.length == 2 && ADDRESS_PATTERN.matcher(ipAndHost[0]).matches();
    }

    public static String toServiceName(String group) {
        return "consul_" + group;
    }

    private static String toServicePath(ConsulURL url) {
        String name = url.getServiceInterface();
        String group = url.getGroup();
        return group + "/" + ConsulURL.encode(name);
    }

    public static String toCategoryPathNotIncludeVersion(ConsulURL url, ThrallRoleType roleType) {
        switch (roleType) {
            case CONSUMER: {
                return ConsulURLUtils.toServicePath(url) + "/" + "consumers";
            }
            case PROVIDER: {
                return ConsulURLUtils.toServicePath(url) + "/" + "providers";
            }
        }
        throw new IllegalArgumentException("there is no role type");
    }

    public static String toCategoryPathIncludeVersion(ConsulURL url, ThrallRoleType roleType) {
        switch (roleType) {
            case CONSUMER: {
                return ConsulURLUtils.toServicePath(url) + "/" + url.getVersion() + "/" + "consumers";
            }
            case PROVIDER: {
                return ConsulURLUtils.toServicePath(url) + "/" + url.getVersion() + "/" + "providers";
            }
        }
        throw new IllegalArgumentException("there is no role type");
    }

    public static String healthServicePath(ConsulURL url, ThrallRoleType roleType) {
        return ConsulURLUtils.toCategoryPathNotIncludeVersion(url, roleType) + "/" + ConsulURL.encode(url.toFullString());
    }

    public static String ephemralNodePath(ConsulURL url, ThrallRoleType roleType) {
        return "consul_" + ConsulURLUtils.toCategoryPathIncludeVersion(url, roleType) + "/" + url.getAddress();
    }
}

