/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul.internal;

import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.registry.consul.common.ConsulConstants;
import com.alipay.sofa.rpc.registry.consul.model.ConsulSession;
import com.alipay.sofa.rpc.registry.consul.model.HeartbeatService;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtlScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TtlScheduler.class);
    private final Set<HeartbeatService> services = Sets.newConcurrentHashSet();
    private final Set<ConsulSession> sessions = Sets.newConcurrentHashSet();
    private final Set<HeartbeatService> failedservices = Sets.newConcurrentHashSet();
    private final Set<ConsulSession> failedsessions = Sets.newConcurrentHashSet();
    private final ScheduledExecutorService heartbeatServiceExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("CheckServiceTimer", true));
    private final ScheduledExecutorService heartbeatSessionExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("CheckSessionTimer", true));
    private final ConsulClient client;

    public TtlScheduler(ConsulClient client) {
        this.client = client;
        this.heartbeatServiceExecutor.scheduleAtFixedRate(new ConsulHeartbeatServiceTask(), ConsulConstants.HEARTBEAT_CIRCLE, ConsulConstants.HEARTBEAT_CIRCLE, TimeUnit.MILLISECONDS);
        this.heartbeatSessionExecutor.scheduleAtFixedRate(new ConsulHeartbeatSessionTask(), ConsulConstants.HEARTBEAT_CIRCLE, ConsulConstants.HEARTBEAT_CIRCLE, TimeUnit.MILLISECONDS);
    }

    public void addHeartbeatServcie(HeartbeatService service) {
        this.services.add(service);
    }

    public void addHeartbeatSession(ConsulSession session) {
        this.sessions.add(session);
    }

    public void removeHeartbeatServcie(HeartbeatService service) {
        this.services.remove(service);
    }

    public Set<HeartbeatService> getFailedService() {
        return this.failedservices;
    }

    public Set<ConsulSession> getFailedSession() {
        return this.failedsessions;
    }

    public void cleanFailedTtl() {
        this.failedsessions.clear();
        this.failedservices.clear();
    }

    private class ConsulHeartbeatSessionTask
    implements Runnable {
        private ConsulHeartbeatSessionTask() {
        }

        @Override
        public void run() {
            HashSet sessionIds = Sets.newHashSet();
            for (ConsulSession session : TtlScheduler.this.sessions) {
                try {
                    String sessionId = session.getSessionId();
                    if (!sessionIds.contains(sessionId)) {
                        TtlScheduler.this.client.renewSession(sessionId, QueryParams.DEFAULT);
                        sessionIds.add(sessionId);
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Sending consul heartbeat for: {}", (Object)sessionId);
                }
                catch (Throwable e) {
                    TtlScheduler.this.failedsessions.addAll(TtlScheduler.this.sessions);
                    TtlScheduler.this.sessions.clear();
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }
    }

    private class ConsulHeartbeatServiceTask
    implements Runnable {
        private ConsulHeartbeatServiceTask() {
        }

        @Override
        public void run() {
            for (HeartbeatService service : TtlScheduler.this.services) {
                try {
                    String checkId = service.getNewService().getId();
                    if (!checkId.startsWith("service:")) {
                        checkId = "service:" + checkId;
                    }
                    TtlScheduler.this.client.agentCheckPass(checkId);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Sending consul heartbeat for: {}", (Object)checkId);
                }
                catch (Throwable e) {
                    TtlScheduler.this.failedservices.add(service);
                    TtlScheduler.this.services.remove(service);
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }
    }
}

