/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.nacos.NacosRegistryHelper;
import com.alipay.sofa.rpc.registry.nacos.NacosRegistryProviderObserver;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Extension(value="nacos")
public class NacosRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosRegistry.class);
    private static final String DEFAULT_NAMESPACE = "sofa-rpc";
    private NamingService namingService;
    private NacosRegistryProviderObserver providerObserver;
    private List<String> defaultCluster;
    private ConcurrentMap<ProviderConfig, List<Instance>> providerInstances = new ConcurrentHashMap<ProviderConfig, List<Instance>>();
    private ConcurrentMap<ConsumerConfig, EventListener> consumerListeners = new ConcurrentHashMap<ConsumerConfig, EventListener>();
    private Properties nacosConfig = new Properties();

    public NacosRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    @Override
    public synchronized void init() {
        String namespace;
        String address;
        if (this.namingService != null) {
            return;
        }
        String addressInput = this.registryConfig.getAddress();
        if (StringUtils.isEmpty(addressInput)) {
            throw new SofaRpcRuntimeException("Address of nacos registry is empty.");
        }
        int idx = addressInput.indexOf("/");
        if (idx > 0) {
            address = addressInput.substring(0, idx);
            namespace = addressInput.substring(idx + 1);
            if (StringUtils.isBlank(namespace)) {
                namespace = DEFAULT_NAMESPACE;
            }
        } else {
            address = addressInput;
            namespace = DEFAULT_NAMESPACE;
        }
        this.defaultCluster = Collections.singletonList("default-cluster");
        this.nacosConfig.put("serverAddr", address);
        this.nacosConfig.put("namespace", namespace);
        try {
            this.namingService = NamingFactory.createNamingService((Properties)this.nacosConfig);
        }
        catch (NacosException e) {
            throw new SofaRpcRuntimeException("Init nacos naming service error, address: " + address);
        }
    }

    @Override
    public boolean start() {
        if (this.namingService == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Nacos client should be initialized before starting.");
            }
            return false;
        }
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (config.isRegister()) {
            try {
                List<Instance> instances = NacosRegistryHelper.convertProviderToInstances(config);
                if (CommonUtils.isNotEmpty(instances)) {
                    String serviceName = config.getInterfaceId();
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00205", serviceName));
                    }
                    for (Instance instance : instances) {
                        this.namingService.registerInstance(serviceName, instance);
                    }
                    this.providerInstances.put(config, instances);
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00206", serviceName));
                    }
                }
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to register provider to nacosRegistry!", e);
            }
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        block8: {
            String appName = config.getAppName();
            if (!this.registryConfig.isRegister()) {
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
                }
                return;
            }
            if (config.isRegister()) {
                String serviceName = config.getInterfaceId();
                try {
                    List instances = (List)this.providerInstances.remove(config);
                    if (CommonUtils.isNotEmpty(instances)) {
                        for (Instance instance : instances) {
                            this.namingService.deregisterInstance(serviceName, instance.getIp(), instance.getPort(), instance.getClusterName());
                        }
                        if (LOGGER.isInfoEnabled(appName)) {
                            LOGGER.infoWithApp(appName, LogCodes.getLog("00203", serviceName, instances.size()));
                        }
                    }
                }
                catch (Exception e) {
                    if (RpcRunningState.isShuttingDown()) break block8;
                    throw new SofaRpcRuntimeException("Failed to unregister provider to nacos registry! service: " + serviceName, e);
                }
            }
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unRegister(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Batch unregister from nacos error", e);
            }
        }
    }

    @Override
    public List<ProviderGroup> subscribe(final ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return null;
        }
        if (config.isSubscribe()) {
            String serviceName = config.getInterfaceId();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00202", serviceName));
            }
            try {
                if (this.providerObserver == null) {
                    this.providerObserver = new NacosRegistryProviderObserver();
                }
                ProviderInfoListener providerInfoListener = config.getProviderInfoListener();
                this.providerObserver.addProviderListener(config, providerInfoListener);
                EventListener eventListener = new EventListener(){

                    public void onEvent(Event event) {
                        if (event instanceof NamingEvent) {
                            NamingEvent namingEvent = (NamingEvent)event;
                            ArrayList<Instance> instances = namingEvent.getInstances();
                            if (null == instances) {
                                instances = new ArrayList<Instance>();
                            }
                            NacosRegistry.this.providerObserver.updateProviders(config, instances);
                        }
                    }
                };
                this.namingService.subscribe(serviceName, this.defaultCluster, eventListener);
                this.consumerListeners.put(config, eventListener);
                List allInstances = this.namingService.getAllInstances(serviceName, this.defaultCluster);
                List<ProviderInfo> providerInfos = NacosRegistryHelper.convertInstancesToProviders(allInstances);
                List<ProviderInfo> matchProviders = RegistryUtils.matchProviderInfos(config, providerInfos);
                return Collections.singletonList(new ProviderGroup().addAll(matchProviders));
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to subscribe provider from nacosRegistry, service: " + serviceName, e);
            }
        }
        return null;
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        if (config.isSubscribe()) {
            block4: {
                String serviceName = config.getInterfaceId();
                try {
                    EventListener eventListener = (EventListener)this.consumerListeners.remove(config);
                    if (null != eventListener) {
                        this.namingService.unsubscribe(serviceName, this.defaultCluster, eventListener);
                    }
                }
                catch (Exception e) {
                    if (RpcRunningState.isShuttingDown()) break block4;
                    throw new SofaRpcRuntimeException("Failed to unsubscribe listener from nacosRegistry, service:" + serviceName, e);
                }
            }
            this.providerObserver.removeProviderListener(config);
        }
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            this.unSubscribe(config);
        }
    }

    @Override
    public void destroy() {
        for (ProviderConfig providerConfig : this.providerInstances.keySet()) {
            this.unRegister(providerConfig);
        }
        for (ConsumerConfig consumerConfig : this.consumerListeners.keySet()) {
            this.unSubscribe(consumerConfig);
        }
        this.namingService = null;
        this.providerObserver = null;
    }

    public Properties getNacosConfig() {
        return this.nacosConfig;
    }
}

