/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import com.alipay.sofa.rpc.registry.zk.ZookeeperRegistryHelper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperConfigObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfigObserver.class);
    private ConcurrentMap<AbstractInterfaceConfig, List<ConfigListener>> configListenerMap = new ConcurrentHashMap<AbstractInterfaceConfig, List<ConfigListener>>();

    public void addConfigListener(AbstractInterfaceConfig config, ConfigListener listener) {
        if (listener != null) {
            RegistryUtils.initOrAddList(this.configListenerMap, config, listener);
        }
    }

    public void removeConfigListener(AbstractInterfaceConfig config) {
        this.configListenerMap.remove(config);
    }

    public void updateConfig(AbstractInterfaceConfig config, String configPath, ChildData data) {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive update data is null");
            }
        } else {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive update data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            this.notifyListeners(config, configPath, data, false);
        }
    }

    public void updateConfigAll(AbstractInterfaceConfig config, String configPath, List<ChildData> currentData) {
        if (CommonUtils.isEmpty(currentData)) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive updateAll data is null");
            }
        } else {
            List configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                for (ChildData data : currentData) {
                    LOGGER.infoWithApp(config.getAppName(), "Receive updateAll data: path=[" + data.getPath() + "], data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
                }
            }
            if (CommonUtils.isNotEmpty(configListeners = (List)this.configListenerMap.get(config))) {
                List<Map<String, String>> attributes = ZookeeperRegistryHelper.convertConfigToAttributes(configPath, currentData);
                for (ConfigListener listener : configListeners) {
                    for (Map<String, String> attribute : attributes) {
                        listener.configChanged(attribute);
                    }
                }
            }
        }
    }

    public void removeConfig(AbstractInterfaceConfig config, String configPath, ChildData data) {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive remove data is null");
            }
        } else {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive remove data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            this.notifyListeners(config, configPath, data, true);
        }
    }

    public void addConfig(AbstractInterfaceConfig config, String configPath, ChildData data) {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive add data is null");
            }
        } else {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive add data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            this.notifyListeners(config, configPath, data, false);
        }
    }

    private void notifyListeners(AbstractInterfaceConfig config, String configPath, ChildData data, boolean removeType) {
        List configListeners = (List)this.configListenerMap.get(config);
        if (CommonUtils.isNotEmpty(configListeners)) {
            Map<String, String> attribute = ZookeeperRegistryHelper.convertConfigToAttribute(configPath, data, removeType);
            for (ConfigListener listener : configListeners) {
                listener.configChanged(attribute);
            }
        }
    }
}

